/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.oauth.repository;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.util.Assert;
import top.dcenter.ums.security.core.oauth.justauth.request.Auth2DefaultRequest;
import top.dcenter.ums.security.core.oauth.repository.Auth2DefaultRequestRepository;

public class HttpSessionAuth2DefaultRequestRepository
implements Auth2DefaultRequestRepository<Auth2DefaultRequest> {
    private static final String DEFAULT_AUTHORIZATION_REQUEST_ATTR_NAME = HttpSessionAuth2DefaultRequestRepository.class.getName() + ".AUTH_DEFAULT_REQUEST";
    private final String sessionAttributeName = DEFAULT_AUTHORIZATION_REQUEST_ATTR_NAME;

    @Override
    public Auth2DefaultRequest loadAuthorizationRequest(HttpServletRequest request) {
        Assert.notNull((Object)request, (String)"request cannot be null");
        String stateParameter = this.getStateParameter(request);
        if (stateParameter == null) {
            return null;
        }
        Map<String, Auth2DefaultRequest> authDefaultRequestMap = this.getAuthorizationRequests(request);
        return authDefaultRequestMap.get(stateParameter);
    }

    @Override
    public void saveAuthorizationRequest(Auth2DefaultRequest auth2DefaultRequest, HttpServletRequest request, HttpServletResponse response) {
        Assert.notNull((Object)request, (String)"request cannot be null");
        Assert.notNull((Object)response, (String)"response cannot be null");
        if (auth2DefaultRequest == null) {
            this.removeAuthorizationRequest(request, response);
            return;
        }
        String state = auth2DefaultRequest.getAuthStateCache().get(auth2DefaultRequest.getAuthSource().name());
        Assert.hasText((String)state, (String)"auth2DefaultRequest.state cannot be empty");
        Map<String, Auth2DefaultRequest> authorizationRequests = this.getAuthorizationRequests(request);
        authorizationRequests.put(state, auth2DefaultRequest);
        request.getSession().setAttribute(this.sessionAttributeName, authorizationRequests);
    }

    @Override
    public Auth2DefaultRequest removeAuthorizationRequest(HttpServletRequest request, HttpServletResponse response) {
        Assert.notNull((Object)request, (String)"request cannot be null");
        Assert.notNull((Object)response, (String)"response cannot be null");
        String stateParameter = this.getStateParameter(request);
        if (stateParameter == null) {
            return null;
        }
        Map<String, Auth2DefaultRequest> authorizationRequests = this.getAuthorizationRequests(request);
        Auth2DefaultRequest originalRequest = authorizationRequests.remove(stateParameter);
        if (!authorizationRequests.isEmpty()) {
            request.getSession().setAttribute(this.sessionAttributeName, authorizationRequests);
        } else {
            request.getSession().removeAttribute(this.sessionAttributeName);
        }
        return originalRequest;
    }

    private String getStateParameter(HttpServletRequest request) {
        return request.getParameter("state");
    }

    private Map<String, Auth2DefaultRequest> getAuthorizationRequests(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        Map authDefaultRequestMap = session != null ? (Map)session.getAttribute(this.sessionAttributeName) : null;
        return Optional.ofNullable(authDefaultRequestMap).orElse(new HashMap(0));
    }
}

