/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.oauth.config;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import top.dcenter.ums.security.core.oauth.config.Auth2AutoConfiguration;
import top.dcenter.ums.security.core.oauth.job.RefreshTokenJob;
import top.dcenter.ums.security.core.oauth.job.RefreshTokenJobImpl;
import top.dcenter.ums.security.core.oauth.properties.Auth2Properties;
import top.dcenter.ums.security.core.oauth.properties.ExecutorProperties;
import top.dcenter.ums.security.core.oauth.repository.UsersConnectionRepository;
import top.dcenter.ums.security.core.oauth.repository.UsersConnectionTokenRepository;

@Configuration
@ConditionalOnProperty(prefix="ums.oauth", name={"enabled"}, havingValue="true")
@AutoConfigureAfter(value={Auth2AutoConfiguration.class})
@EnableScheduling
public class ScheduleAutoConfiguration
implements SchedulingConfigurer,
DisposableBean {
    private final Auth2Properties auth2Properties;
    private final ExecutorProperties executorProperties;
    private ScheduledExecutorService accessTokenScheduledExecutorService;
    private ExecutorService updateConnectionExecutorService;
    private ExecutorService refreshTokenExecutorService;

    public ScheduleAutoConfiguration(Auth2Properties auth2Properties, ExecutorProperties executorProperties) {
        this.auth2Properties = auth2Properties;
        this.executorProperties = executorProperties;
    }

    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        taskRegistrar.setScheduler((Object)this.accessTokenScheduledExecutorService);
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.oauth.job.RefreshTokenJob"})
    @ConditionalOnProperty(prefix="ums.oauth", name={"enableRefreshTokenJob"}, havingValue="true")
    public RefreshTokenJob refreshTokenJob(UsersConnectionTokenRepository usersConnectionTokenRepository, UsersConnectionRepository usersConnectionRepository, @Qualifier(value="accessTokenJobTaskExecutor") ScheduledExecutorService accessTokenJobTaskExecutor, @Qualifier(value="refreshTokenTaskExecutor") ExecutorService refreshTokenTaskExecutor) {
        return new RefreshTokenJobImpl(usersConnectionRepository, usersConnectionTokenRepository, this.auth2Properties, accessTokenJobTaskExecutor, refreshTokenTaskExecutor);
    }

    @Bean
    @ConditionalOnProperty(prefix="ums.oauth", name={"enableRefreshTokenJob"}, havingValue="true")
    public ScheduledExecutorService accessTokenJobTaskExecutor() {
        ExecutorProperties.AccessTokenRefreshJobExecutorProperties accessTokenRefreshJob = this.executorProperties.getAccessTokenRefreshJob();
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(accessTokenRefreshJob.getCorePoolSize(), this.getThreadFactory(accessTokenRefreshJob.getPoolName()), accessTokenRefreshJob.getRejectedExecutionHandlerPolicy().getRejectedHandler());
        scheduledThreadPoolExecutor.setKeepAliveTime(accessTokenRefreshJob.getKeepAliveTime().intValue(), accessTokenRefreshJob.getTimeUnit());
        this.accessTokenScheduledExecutorService = scheduledThreadPoolExecutor;
        return scheduledThreadPoolExecutor;
    }

    @Bean
    @ConditionalOnProperty(prefix="ums.oauth", name={"enableRefreshTokenJob"}, havingValue="true")
    public ExecutorService refreshTokenTaskExecutor() {
        ExecutorProperties.RefreshTokenExecutorProperties refreshToken = this.executorProperties.getRefreshToken();
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(refreshToken.getCorePoolSize(), refreshToken.getMaximumPoolSize(), refreshToken.getKeepAliveTime().intValue(), refreshToken.getTimeUnit(), new LinkedBlockingQueue<Runnable>(refreshToken.getBlockingQueueCapacity()), this.getThreadFactory(refreshToken.getPoolName()), refreshToken.getRejectedExecutionHandlerPolicy().getRejectedHandler());
        this.refreshTokenExecutorService = threadPoolExecutor;
        return threadPoolExecutor;
    }

    @Bean(destroyMethod="shutdown")
    public ExecutorService updateConnectionTaskExecutor() {
        ExecutorProperties.UserConnectionUpdateExecutorProperties userConnectionUpdate = this.executorProperties.getUserConnectionUpdate();
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(userConnectionUpdate.getCorePoolSize(), userConnectionUpdate.getMaximumPoolSize(), userConnectionUpdate.getKeepAliveTime().intValue(), userConnectionUpdate.getTimeUnit(), new LinkedBlockingQueue<Runnable>(userConnectionUpdate.getBlockingQueueCapacity()), this.getThreadFactory(userConnectionUpdate.getPoolName()), userConnectionUpdate.getRejectedExecutionHandlerPolicy().getRejectedHandler());
        this.updateConnectionExecutorService = threadPoolExecutor;
        return threadPoolExecutor;
    }

    private ThreadFactory getThreadFactory(String poolName) {
        return new DefaultThreadFactory(poolName);
    }

    public void shutdown() throws Exception {
        if (this.updateConnectionExecutorService != null) {
            this.updateConnectionExecutorService.shutdown();
            this.updateConnectionExecutorService.awaitTermination(this.executorProperties.getUserConnectionUpdate().getExecutorShutdownTimeout().toMillis(), TimeUnit.MILLISECONDS);
            if (!this.updateConnectionExecutorService.isTerminated()) {
                this.updateConnectionExecutorService.shutdownNow();
            }
        }
    }

    public void destroy() throws Exception {
        if (this.refreshTokenExecutorService != null) {
            this.refreshTokenExecutorService.shutdown();
            this.refreshTokenExecutorService.awaitTermination(this.executorProperties.getAccessTokenRefreshJob().getExecutorShutdownTimeout().toMillis(), TimeUnit.MILLISECONDS);
            if (!this.refreshTokenExecutorService.isTerminated()) {
                this.refreshTokenExecutorService.shutdownNow();
            }
        }
        if (this.accessTokenScheduledExecutorService != null) {
            this.accessTokenScheduledExecutorService.shutdown();
            this.accessTokenScheduledExecutorService.awaitTermination(this.executorProperties.getAccessTokenRefreshJob().getExecutorShutdownTimeout().toMillis(), TimeUnit.MILLISECONDS);
            if (!this.accessTokenScheduledExecutorService.isTerminated()) {
                this.accessTokenScheduledExecutorService.shutdownNow();
            }
        }
    }

    private static class DefaultThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger POOL_NUMBER = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        DefaultThreadFactory(String poolName) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = poolName + "-" + POOL_NUMBER.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(@NonNull Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

