/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.oauth.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.annotation.Scheduled;

public class MvcUtil {
    private static final Logger log = LoggerFactory.getLogger(MvcUtil.class);
    private static String servletContextPath = "";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static String getServletContextPath() {
        return servletContextPath;
    }

    public static String toJsonString(Object obj) {
        try {
            return OBJECT_MAPPER.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            String msg = String.format("Object2JsonString \u5931\u8d25: %s, Object=%s", e.getMessage(), obj);
            log.error(msg, (Throwable)e);
            return "";
        }
    }

    public static void setScheduledCron(@NonNull String methodName, @NonNull String cronValue, @NonNull Class<?> targetClass, Class<?> ... parameterTypes) throws Exception {
        Method method = targetClass.getDeclaredMethod(methodName, parameterTypes);
        method.setAccessible(true);
        Scheduled annotation = method.getDeclaredAnnotation(Scheduled.class);
        if (null == annotation) {
            String msg = String.format("\u8bbe\u7f6e %s#%s() \u65b9\u6cd5\u7684 cron \u6620\u5c04\u503c\u65f6\u53d1\u751f\u9519\u8bef.", targetClass.getName(), methodName);
            log.error(msg);
            throw new RuntimeException(msg);
        }
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(annotation);
        Field memberValuesField = invocationHandler.getClass().getDeclaredField("memberValues");
        memberValuesField.setAccessible(true);
        Map memberValuesValue = (Map)memberValuesField.get(invocationHandler);
        memberValuesValue.put("cron", cronValue);
    }

    public static String[] splitByCharacterTypeCamelCase(String str, boolean camelCase) {
        if (str == null) {
            return null;
        }
        if (str.isEmpty()) {
            return new String[0];
        }
        char[] c = str.toCharArray();
        ArrayList<String> list = new ArrayList<String>();
        int tokenStart = 0;
        int currentType = Character.getType(c[tokenStart]);
        for (int pos = tokenStart + 1; pos < c.length; ++pos) {
            int type = Character.getType(c[pos]);
            if (type == currentType) continue;
            if (camelCase && type == 2 && currentType == 1) {
                int newTokenStart = pos - 1;
                if (newTokenStart != tokenStart) {
                    list.add(new String(c, tokenStart, newTokenStart - tokenStart));
                    tokenStart = newTokenStart;
                }
            } else {
                list.add(new String(c, tokenStart, pos - tokenStart));
                tokenStart = pos;
            }
            currentType = type;
        }
        list.add(new String(c, tokenStart, c.length - tokenStart));
        return list.toArray(new String[0]);
    }

    static {
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

