/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.mdc.filter;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import me.zhyd.oauth.utils.UuidUtils;
import org.slf4j.MDC;
import org.springframework.lang.NonNull;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.UrlPathHelper;
import top.dcenter.ums.security.core.mdc.properties.MdcProperties;

public class MdcLogFilter
extends OncePerRequestFilter {
    public static final String MDC_KEY = "MDC_TRACE_ID";
    private final Set<String> includeUrls;
    private final Set<String> excludeUrls;
    private final AntPathMatcher matcher = new AntPathMatcher();
    private final UrlPathHelper helper;

    public MdcLogFilter(MdcProperties mdcProperties) {
        this.includeUrls = new HashSet<String>();
        this.excludeUrls = new HashSet<String>();
        this.helper = new UrlPathHelper();
        this.helper.setAlwaysUseFullPath(true);
        this.includeUrls.addAll(mdcProperties.getIncludeUrls());
        Set<String> excludeUrls = mdcProperties.getExcludeUrls();
        if (null != excludeUrls) {
            this.excludeUrls.addAll(excludeUrls);
        }
    }

    protected void doFilterInternal(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull FilterChain filterChain) throws ServletException, IOException {
        if (this.isMdc(request)) {
            String token = UuidUtils.getUUID();
            MDC.put((String)MDC_KEY, (String)token);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            MDC.remove((String)MDC_KEY);
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private boolean isMdc(HttpServletRequest request) {
        String requestUri = this.helper.getPathWithinApplication(request);
        for (String excludeUrl : this.excludeUrls) {
            if (!this.matcher.match(excludeUrl, requestUri)) continue;
            return false;
        }
        for (String includeUrl : this.includeUrls) {
            if (!this.matcher.match(includeUrl, requestUri)) continue;
            return true;
        }
        return false;
    }
}

