/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.oauth.job;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.util.Assert;
import top.dcenter.ums.security.core.oauth.job.RefreshTokenJob;
import top.dcenter.ums.security.core.oauth.properties.Auth2Properties;
import top.dcenter.ums.security.core.oauth.util.MvcUtil;

public class RefreshAccessTokenJobHandler
implements InitializingBean {
    private final Auth2Properties auth2Properties;
    private final ScheduledExecutorService jobTaskScheduledExecutor;
    @Autowired
    private Map<String, RefreshTokenJob> refreshTokenJobMap;

    public RefreshAccessTokenJobHandler(Auth2Properties auth2Properties, @Qualifier(value="jobTaskScheduledExecutor") ScheduledExecutorService jobTaskScheduledExecutor) {
        Assert.notNull((Object)jobTaskScheduledExecutor, (String)"jobTaskScheduledExecutor cannot be null");
        Assert.notNull((Object)auth2Properties, (String)"auth2Properties cannot be null");
        this.jobTaskScheduledExecutor = jobTaskScheduledExecutor;
        this.auth2Properties = auth2Properties;
    }

    @Scheduled(cron="0 * 4 * * ?")
    public void refreshAccessTokenJob() {
        this.jobTaskScheduledExecutor.schedule(() -> {
            if (this.refreshTokenJobMap == null) {
                return;
            }
            Collection<RefreshTokenJob> validateCodeJobs = this.refreshTokenJobMap.values();
            validateCodeJobs.forEach(RefreshTokenJob::refreshTokenJob);
        }, 10L, TimeUnit.MILLISECONDS);
    }

    public void afterPropertiesSet() throws Exception {
        String methodName = "refreshAccessTokenJob";
        if (this.auth2Properties.getEnableRefreshTokenJob().booleanValue()) {
            MvcUtil.setScheduledCron(methodName, this.auth2Properties.getRefreshTokenJobCron(), this.getClass(), new Class[0]);
        }
    }
}

