/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.mdc.filter;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.UrlPathHelper;
import top.dcenter.ums.security.core.mdc.MdcIdGenerator;
import top.dcenter.ums.security.core.mdc.MdcIdType;
import top.dcenter.ums.security.core.mdc.properties.MdcProperties;
import top.dcenter.ums.security.core.mdc.utils.MdcUtil;

public class MdcLogFilter
extends OncePerRequestFilter {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String MDC_KEY = "MDC_TRACE_ID";
    @Autowired(required=false)
    private MdcIdGenerator mdcIdGenerator;
    private final Set<String> includeUrls;
    private final Set<String> excludeUrls;
    private final AntPathMatcher matcher;
    private final UrlPathHelper helper;
    private final MdcIdType idType;

    public MdcLogFilter(MdcProperties mdcProperties) {
        this.idType = mdcProperties.getType();
        this.matcher = new AntPathMatcher();
        this.includeUrls = new HashSet<String>();
        this.excludeUrls = new HashSet<String>();
        this.helper = new UrlPathHelper();
        this.helper.setAlwaysUseFullPath(true);
        this.includeUrls.addAll(mdcProperties.getIncludeUrls());
        Set<String> excludeUrls = mdcProperties.getExcludeUrls();
        if (null != excludeUrls) {
            this.excludeUrls.addAll(excludeUrls);
        }
    }

    protected void doFilterInternal(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull FilterChain filterChain) throws ServletException, IOException {
        if (this.isEnableMdc(request)) {
            String token = MdcUtil.getMdcId(this.idType, this.mdcIdGenerator);
            MDC.put((String)MDC_KEY, (String)token);
            try {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
                request.setAttribute(MDC_KEY, (Object)token);
                MDC.clear();
                throw e;
            }
            MDC.clear();
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private boolean isEnableMdc(HttpServletRequest request) {
        String requestUri = this.helper.getPathWithinApplication(request);
        for (String excludeUrl : this.excludeUrls) {
            if (!this.matcher.match(excludeUrl, requestUri)) continue;
            return false;
        }
        for (String includeUrl : this.includeUrls) {
            if (!this.matcher.match(includeUrl, requestUri)) continue;
            return true;
        }
        return false;
    }
}

