/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.mdc.utils;

import java.util.Map;
import org.slf4j.MDC;
import org.springframework.lang.Nullable;
import top.dcenter.ums.security.core.mdc.MdcIdGenerator;
import top.dcenter.ums.security.core.mdc.MdcIdType;

public final class MdcUtil {
    private MdcUtil() {
    }

    @Nullable
    public static String getMdcTraceId() {
        try {
            return MDC.get((String)"MDC_TRACE_ID");
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getMdcId(MdcIdType type, MdcIdGenerator idGenerator) {
        if (MdcIdType.CUSTOMIZE_ID.equals(type) && idGenerator != null) {
            return idGenerator.getMdcId();
        }
        return type.getMdcId();
    }

    public static Runnable decorateTasks(Runnable task, MdcIdType idType, MdcIdGenerator idGenerator) {
        return () -> {
            Map contextMap = MDC.getCopyOfContextMap();
            boolean isRemoveMdcId = false;
            if (contextMap == null) {
                MDC.put((String)"MDC_TRACE_ID", (String)MdcUtil.getMdcId(idType, idGenerator));
                isRemoveMdcId = true;
            }
            task.run();
            if (isRemoveMdcId) {
                MDC.clear();
            }
        };
    }
}

