/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.advice;

import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import top.dcenter.ums.security.core.oauth.exception.AbstractResponseJsonAuthenticationException;
import top.dcenter.ums.security.core.oauth.exception.Auth2Exception;
import top.dcenter.ums.security.core.oauth.exception.RefreshTokenFailureException;
import top.dcenter.ums.security.core.vo.ResponseResult;

@Order(value=100)
@ControllerAdvice
public class Auth2ControllerAdviceHandler {
    @ExceptionHandler(value={AbstractResponseJsonAuthenticationException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ResponseResult abstractResponseJsonAuthenticationException(AbstractResponseJsonAuthenticationException ex) {
        String errorMsg = ex.getMessage();
        return ResponseResult.fail(errorMsg, ex.getErrorCodeEnum(), ex.getData());
    }

    @ExceptionHandler(value={Auth2Exception.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.NOT_IMPLEMENTED)
    public ResponseResult auth2Exception(Auth2Exception ex) {
        return ResponseResult.fail(ex.getMessage(), ex.getErrorCodeEnum(), ex.getData());
    }

    @ExceptionHandler(value={RefreshTokenFailureException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ResponseResult refreshTokenFailureException(RefreshTokenFailureException ex) {
        return ResponseResult.fail(ex.getMessage(), ex.getErrorCodeEnum(), ex.getData());
    }
}

