/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.oauth.provider;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import javax.servlet.http.HttpServletRequest;
import me.zhyd.oauth.model.AuthUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.security.authentication.AccountExpiredException;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.CredentialsExpiredException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.SpringSecurityMessageSource;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserCache;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsChecker;
import org.springframework.security.core.userdetails.cache.NullUserCache;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import top.dcenter.ums.security.core.oauth.entity.ConnectionData;
import top.dcenter.ums.security.core.oauth.justauth.request.Auth2DefaultRequest;
import top.dcenter.ums.security.core.oauth.service.Auth2UserService;
import top.dcenter.ums.security.core.oauth.service.UmsUserDetailsService;
import top.dcenter.ums.security.core.oauth.signup.ConnectionService;
import top.dcenter.ums.security.core.oauth.token.Auth2AuthenticationToken;
import top.dcenter.ums.security.core.oauth.token.Auth2LoginAuthenticationToken;
import top.dcenter.ums.security.core.oauth.userdetails.TemporaryUser;
import top.dcenter.ums.security.core.oauth.util.MvcUtil;

public class Auth2LoginAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger log = LoggerFactory.getLogger(Auth2LoginAuthenticationProvider.class);
    private final Auth2UserService userService;
    private final UmsUserDetailsService umsUserDetailsService;
    private final ConnectionService connectionService;
    private final ExecutorService updateConnectionTaskExecutor;
    private final Boolean autoSignUp;
    private final String temporaryUserAuthorities;
    private final String temporaryUserPassword;
    protected MessageSourceAccessor messages = SpringSecurityMessageSource.getAccessor();
    private UserCache userCache = new NullUserCache();
    private UserDetailsChecker preAuthenticationChecks = new DefaultPreAuthenticationChecks();
    private UserDetailsChecker postAuthenticationChecks = new DefaultPostAuthenticationChecks();

    public Auth2LoginAuthenticationProvider(Auth2UserService userService, ConnectionService connectionService, UmsUserDetailsService umsUserDetailsService, ExecutorService updateConnectionTaskExecutor, Boolean autoSignUp, String temporaryUserAuthorities, String temporaryUserPassword) {
        Assert.notNull((Object)updateConnectionTaskExecutor, (String)"updateConnectionTaskExecutor cannot be null");
        Assert.notNull((Object)userService, (String)"userService cannot be null");
        Assert.notNull((Object)connectionService, (String)"connectionService cannot be null");
        Assert.notNull((Object)umsUserDetailsService, (String)"umsUserDetailsService cannot be null");
        Assert.notNull((Object)autoSignUp, (String)"autoSignUp cannot be null");
        Assert.notNull((Object)temporaryUserAuthorities, (String)"temporaryUserAuthorities cannot be null");
        Assert.notNull((Object)temporaryUserPassword, (String)"temporaryUserPassword cannot be null");
        this.updateConnectionTaskExecutor = updateConnectionTaskExecutor;
        this.connectionService = connectionService;
        this.userService = userService;
        this.umsUserDetailsService = umsUserDetailsService;
        this.autoSignUp = autoSignUp;
        this.temporaryUserAuthorities = temporaryUserAuthorities;
        this.temporaryUserPassword = temporaryUserPassword;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        Auth2LoginAuthenticationToken loginToken = (Auth2LoginAuthenticationToken)authentication;
        Auth2DefaultRequest auth2DefaultRequest = loginToken.getAuth2DefaultRequest();
        HttpServletRequest request = loginToken.getRequest();
        String encodeState = request.getParameter("state");
        AuthUser authUser = this.userService.loadUser(auth2DefaultRequest, request);
        String providerUserId = authUser.getUuid();
        String providerId = auth2DefaultRequest.getProviderId();
        List<ConnectionData> connectionDataList = this.connectionService.findConnectionByProviderIdAndProviderUserId(providerId, providerUserId);
        Authentication authenticationToken = SecurityContextHolder.getContext().getAuthentication();
        Object principal = null;
        if (authenticationToken != null && authenticationToken.isAuthenticated() && !(authenticationToken instanceof AnonymousAuthenticationToken)) {
            principal = authenticationToken.getPrincipal();
        }
        boolean cacheWasUsed = false;
        UserDetails userDetails = null;
        if (CollectionUtils.isEmpty(connectionDataList)) {
            if (principal == null) {
                userDetails = this.autoSignUp.booleanValue() ? this.connectionService.signUp(authUser, providerId, encodeState) : TemporaryUser.builder().username(authUser.getUsername() + "_" + providerId + "_" + providerUserId).password("{noop}" + this.temporaryUserPassword).authUser(authUser).encodeState(encodeState).disabled(false).accountExpired(false).accountLocked(false).credentialsExpired(false).authorities(AuthorityUtils.commaSeparatedStringToAuthorityList((String)this.temporaryUserAuthorities)).build();
            } else if (principal instanceof UserDetails) {
                this.connectionService.binding((UserDetails)principal, authUser, providerId);
            }
        } else {
            String userId;
            ConnectionData connectionData = null;
            if (principal instanceof UserDetails) {
                userDetails = (UserDetails)principal;
                userId = userDetails.getUsername();
                for (ConnectionData data : connectionDataList) {
                    if (!userId.equals(data.getUserId())) continue;
                    connectionData = data;
                    break;
                }
                if (connectionData == null) {
                    userDetails = null;
                    principal = null;
                }
            }
            if (userDetails == null) {
                connectionData = connectionDataList.get(0);
                userId = connectionData.getUserId();
                userDetails = this.userCache.getUserFromCache(userId);
                cacheWasUsed = true;
                if (userDetails == null) {
                    cacheWasUsed = false;
                    userDetails = this.umsUserDetailsService.loadUserByUserId(userId);
                }
            }
            this.asyncUpdateUserConnectionAndToken(authUser, connectionData);
        }
        Auth2DefaultRequest.removeStateCacheOfSessionCache(auth2DefaultRequest.getAuthStateCache(), auth2DefaultRequest.getAuthSource());
        if (principal != null) {
            return authenticationToken;
        }
        try {
            this.preAuthenticationChecks.check(userDetails);
            this.additionalAuthenticationChecks(userDetails, (Auth2LoginAuthenticationToken)authentication);
        }
        catch (AuthenticationException exception) {
            if (cacheWasUsed) {
                cacheWasUsed = false;
                userDetails = this.umsUserDetailsService.loadUserByUserId(userDetails.getUsername());
                this.preAuthenticationChecks.check(userDetails);
                this.additionalAuthenticationChecks(userDetails, (Auth2LoginAuthenticationToken)authentication);
            }
            throw exception;
        }
        this.postAuthenticationChecks.check(userDetails);
        if (!cacheWasUsed) {
            this.userCache.putUserInCache(userDetails);
        }
        Auth2AuthenticationToken auth2AuthenticationToken = new Auth2AuthenticationToken(userDetails, userDetails.getAuthorities(), providerId);
        auth2AuthenticationToken.setDetails(loginToken.getDetails());
        return auth2AuthenticationToken;
    }

    private void asyncUpdateUserConnectionAndToken(AuthUser authUser, ConnectionData connectionData) {
        try {
            this.updateConnectionTaskExecutor.execute(() -> {
                try {
                    this.connectionService.updateUserConnectionAndAuthToken(authUser, connectionData);
                }
                catch (Exception e) {
                    String msg = String.format("\u5f02\u6b65\u66f4\u65b0\u7b2c\u4e09\u65b9\u6388\u6743\u767b\u5f55\u7528\u6237\u4fe1\u606f\u4e0e token \u4fe1\u606f\u5931\u8d25: AuthUser=%s, ConnectionData=%s, error=%s", MvcUtil.toJsonString(authUser), MvcUtil.toJsonString(connectionData), e.getMessage());
                    log.error(msg, (Throwable)e);
                }
            });
        }
        catch (NullPointerException | RejectedExecutionException e) {
            log.error(String.format("\u5f02\u6b65\u66f4\u65b0\u7b2c\u4e09\u65b9\u6388\u6743\u767b\u5f55\u7528\u6237\u4fe1\u606f\u4e0e token \u4fe1\u606f\u5931\u8d25: %s, \u518d\u6b21\u540c\u6b65\u66f4\u65b0", e.getMessage()), (Throwable)e);
            try {
                this.connectionService.updateUserConnectionAndAuthToken(authUser, connectionData);
            }
            catch (Exception ex) {
                String msg = String.format("\u540c\u6b65\u66f4\u65b0\u7b2c\u4e09\u65b9\u6388\u6743\u767b\u5f55\u7528\u6237\u4fe1\u606f\u4e0e token \u4fe1\u606f\u5931\u8d25: AuthUser=%s, ConnectionData=%s, error=%s", MvcUtil.toJsonString(authUser), MvcUtil.toJsonString(connectionData), e.getMessage());
                log.error(msg, (Throwable)e);
            }
        }
    }

    protected void additionalAuthenticationChecks(UserDetails userDetails, Auth2LoginAuthenticationToken authentication) throws AuthenticationException {
    }

    public void setUserCache(UserCache userCache) {
        this.userCache = userCache;
    }

    protected UserDetailsChecker getPreAuthenticationChecks() {
        return this.preAuthenticationChecks;
    }

    public void setPreAuthenticationChecks(UserDetailsChecker preAuthenticationChecks) {
        this.preAuthenticationChecks = preAuthenticationChecks;
    }

    protected UserDetailsChecker getPostAuthenticationChecks() {
        return this.postAuthenticationChecks;
    }

    public void setPostAuthenticationChecks(UserDetailsChecker postAuthenticationChecks) {
        this.postAuthenticationChecks = postAuthenticationChecks;
    }

    public boolean supports(Class<?> authentication) {
        return Auth2LoginAuthenticationToken.class.isAssignableFrom(authentication);
    }

    private class DefaultPostAuthenticationChecks
    implements UserDetailsChecker {
        private DefaultPostAuthenticationChecks() {
        }

        public void check(UserDetails user) {
            if (!user.isCredentialsNonExpired()) {
                log.debug("User account credentials have expired");
                throw new CredentialsExpiredException(Auth2LoginAuthenticationProvider.this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.credentialsExpired", "User credentials have expired"));
            }
        }
    }

    private class DefaultPreAuthenticationChecks
    implements UserDetailsChecker {
        private DefaultPreAuthenticationChecks() {
        }

        public void check(UserDetails user) {
            if (!user.isAccountNonLocked()) {
                log.debug("User account is locked");
                throw new LockedException(Auth2LoginAuthenticationProvider.this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.locked", "User account is locked"));
            }
            if (!user.isEnabled()) {
                log.debug("User account is disabled");
                throw new DisabledException(Auth2LoginAuthenticationProvider.this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.disabled", "User is disabled"));
            }
            if (!user.isAccountNonExpired()) {
                log.debug("User account is expired");
                throw new AccountExpiredException(Auth2LoginAuthenticationProvider.this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.expired", "User account has expired"));
            }
        }
    }
}

