/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.oauth.oneclicklogin;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.context.request.ServletWebRequest;
import top.dcenter.ums.security.core.oauth.enums.ErrorCodeEnum;
import top.dcenter.ums.security.core.oauth.exception.Auth2Exception;
import top.dcenter.ums.security.core.oauth.oneclicklogin.OneClickLoginAuthenticationToken;
import top.dcenter.ums.security.core.oauth.oneclicklogin.service.OneClickLoginService;
import top.dcenter.ums.security.core.oauth.properties.OneClickLoginProperties;

public class OneClickLoginAuthenticationFilter
extends AbstractAuthenticationProcessingFilter {
    private final String tokenParamName;
    private final List<String> otherParamNames;
    private final OneClickLoginService oneClickLoginService;
    private boolean postOnly = true;

    public OneClickLoginAuthenticationFilter(@NonNull OneClickLoginService oneClickLoginService, @NonNull OneClickLoginProperties oneClickLoginProperties, @Nullable AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource) {
        super((RequestMatcher)new AntPathRequestMatcher(oneClickLoginProperties.getLoginProcessingUrl(), "POST"));
        this.oneClickLoginService = oneClickLoginService;
        this.tokenParamName = oneClickLoginProperties.getTokenParamName();
        this.otherParamNames = oneClickLoginProperties.getOtherParamNames();
        if (authenticationDetailsSource != null) {
            this.setAuthenticationDetailsSource(authenticationDetailsSource);
        }
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        if (this.postOnly && !request.getMethod().equals("POST")) {
            throw new AuthenticationServiceException("Authentication method not supported: " + request.getMethod());
        }
        String accessToken = this.obtainAccessToken(request);
        if (StringUtils.isEmpty((Object)accessToken)) {
            throw new Auth2Exception(ErrorCodeEnum.MOBILE_NOT_EMPTY, this.tokenParamName);
        }
        accessToken = accessToken.trim();
        Map<String, String> otherParamMap = this.getOtherParamMap(this.otherParamNames, request);
        String mobile = this.oneClickLoginService.callback(accessToken, otherParamMap);
        OneClickLoginAuthenticationToken authRequest = new OneClickLoginAuthenticationToken(mobile, otherParamMap);
        this.setDetails(request, authRequest);
        return this.getAuthenticationManager().authenticate((Authentication)authRequest);
    }

    @Nullable
    protected Map<String, String> getOtherParamMap(@NonNull List<String> otherParamNames, @NonNull HttpServletRequest request) {
        if (otherParamNames.isEmpty()) {
            return null;
        }
        HashMap<String, String> otherMap = new HashMap<String, String>(otherParamNames.size());
        otherParamNames.forEach(name -> {
            block2: {
                try {
                    String value = ServletRequestUtils.getStringParameter((ServletRequest)request, (String)name);
                    otherMap.put((String)name, value);
                }
                catch (ServletRequestBindingException e) {
                    String headerValue = request.getHeader(name);
                    if (!Objects.nonNull(headerValue)) break block2;
                    otherMap.put((String)name, headerValue);
                }
            }
        });
        return otherMap;
    }

    protected String obtainAccessToken(HttpServletRequest request) {
        ServletWebRequest servletWebRequest = new ServletWebRequest(request, null);
        return servletWebRequest.getParameter(this.tokenParamName);
    }

    protected void setDetails(HttpServletRequest request, OneClickLoginAuthenticationToken authRequest) {
        authRequest.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
    }

    public void setPostOnly(boolean postOnly) {
        this.postOnly = postOnly;
    }
}

