/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.oauth.filter.login;

import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.event.InteractiveAuthenticationSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import top.dcenter.ums.security.core.oauth.filter.login.Auth2AuthorizationResponseUtils;
import top.dcenter.ums.security.core.oauth.filter.redirect.Auth2DefaultRequestResolver;
import top.dcenter.ums.security.core.oauth.justauth.Auth2RequestHolder;
import top.dcenter.ums.security.core.oauth.justauth.request.Auth2DefaultRequest;
import top.dcenter.ums.security.core.oauth.token.Auth2LoginAuthenticationToken;
import top.dcenter.ums.security.core.oauth.userdetails.TemporaryUser;
import top.dcenter.ums.security.core.oauth.util.MvcUtil;

public class Auth2LoginAuthenticationFilter
extends AbstractAuthenticationProcessingFilter {
    public static final String TEMPORARY_USER_CACHE_KEY_PREFIX = "TEMPORARY_USER_REDIS_CACHE_KEY:";
    public static final String TEMPORARY_USERNAME_PARAM_NAME = "temporary_username";
    private static final String AUTHORIZATION_REQUEST_NOT_FOUND_ERROR_CODE = "authorization_request_not_found";
    private final Auth2DefaultRequestResolver authorizationRequestResolver;
    private final RedisConnectionFactory redisConnectionFactory;
    private RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
    private final String signUpUrl;

    public Auth2LoginAuthenticationFilter(@NonNull String filterProcessesUrl, @Nullable String signUpUrl, @Nullable AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource, @Autowired(required=false) @Nullable RedisConnectionFactory redisConnectionFactory) {
        super(filterProcessesUrl + "/*");
        this.authorizationRequestResolver = new Auth2DefaultRequestResolver(filterProcessesUrl);
        this.signUpUrl = signUpUrl;
        this.redisConnectionFactory = redisConnectionFactory;
        if (authenticationDetailsSource != null) {
            this.setAuthenticationDetailsSource(authenticationDetailsSource);
        }
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        MultiValueMap<String, String> params = Auth2AuthorizationResponseUtils.toMultiMap(request.getParameterMap());
        if (!Auth2AuthorizationResponseUtils.isAuthorizationResponse(params)) {
            OAuth2Error oauth2Error = new OAuth2Error("invalid_request");
            throw new OAuth2AuthenticationException(oauth2Error, oauth2Error.toString());
        }
        String registrationId = this.authorizationRequestResolver.resolveRegistrationId(request);
        Auth2DefaultRequest auth2DefaultRequest = null;
        if (StringUtils.hasText((String)registrationId)) {
            auth2DefaultRequest = Auth2RequestHolder.getAuth2DefaultRequest(registrationId);
        }
        if (auth2DefaultRequest == null) {
            OAuth2Error oauth2Error = new OAuth2Error(AUTHORIZATION_REQUEST_NOT_FOUND_ERROR_CODE, "Client Registration not found with Id: " + registrationId, null);
            throw new OAuth2AuthenticationException(oauth2Error, oauth2Error.toString());
        }
        Auth2LoginAuthenticationToken authenticationRequest = new Auth2LoginAuthenticationToken(auth2DefaultRequest, request);
        this.setDetails(request, authenticationRequest);
        return this.getAuthenticationManager().authenticate((Authentication)authenticationRequest);
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, FilterChain chain, Authentication authResult) throws IOException, ServletException {
        Object principal;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Authentication success. Updating SecurityContextHolder to contain: " + authResult));
        }
        SecurityContextHolder.getContext().setAuthentication(authResult);
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent((ApplicationEvent)new InteractiveAuthenticationSuccessEvent(authResult, ((Object)((Object)this)).getClass()));
        }
        if ((principal = authResult.getPrincipal()) instanceof TemporaryUser && StringUtils.hasText((String)this.signUpUrl)) {
            TemporaryUser temporaryUser = (TemporaryUser)principal;
            String username = temporaryUser.getUsername();
            String key = TEMPORARY_USER_CACHE_KEY_PREFIX + username;
            if (Objects.nonNull(this.redisConnectionFactory)) {
                try (RedisConnection connection = this.redisConnectionFactory.getConnection();){
                    connection.set(key.getBytes(StandardCharsets.UTF_8), MvcUtil.toJsonString(temporaryUser).getBytes(StandardCharsets.UTF_8), Expiration.from((long)86400L, (TimeUnit)TimeUnit.SECONDS), RedisStringCommands.SetOption.UPSERT);
                }
            } else {
                request.getSession().setAttribute(key, (Object)temporaryUser);
            }
            this.redirectStrategy.sendRedirect(request, response, this.signUpUrl + "?" + TEMPORARY_USERNAME_PARAM_NAME + "=" + URLEncoder.encode(username, StandardCharsets.UTF_8.name()));
            return;
        }
        this.getRememberMeServices().loginSuccess(request, response, authResult);
        this.getSuccessHandler().onAuthenticationSuccess(request, response, authResult);
    }

    protected void setDetails(HttpServletRequest request, Auth2LoginAuthenticationToken authRequest) {
        authRequest.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
    }

    public void setRedirectStrategy(RedirectStrategy redirectStrategy) {
        this.redirectStrategy = redirectStrategy;
    }
}

