/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.tasks.config;

import java.util.concurrent.ScheduledExecutorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import top.dcenter.ums.security.core.mdc.MdcIdGenerator;
import top.dcenter.ums.security.core.mdc.MdcIdType;
import top.dcenter.ums.security.core.mdc.properties.MdcProperties;
import top.dcenter.ums.security.core.mdc.utils.MdcUtil;
import top.dcenter.ums.security.core.oauth.properties.Auth2Properties;
import top.dcenter.ums.security.core.tasks.config.TasksAutoConfiguration;
import top.dcenter.ums.security.core.tasks.handler.RefreshAccessTokenJobHandler;

@Configuration
@AutoConfigureAfter(value={TasksAutoConfiguration.class})
@EnableScheduling
public class ScheduleAutoConfiguration
implements SchedulingConfigurer {
    private final ScheduledExecutorService jobTaskScheduledExecutor;
    private final Auth2Properties auth2Properties;
    private final RefreshAccessTokenJobHandler refreshAccessTokenJobHandler;
    private final MdcIdType mdcIdType;
    @Autowired(required=false)
    private MdcIdGenerator mdcIdGenerator;

    public ScheduleAutoConfiguration(@Qualifier(value="jobTaskScheduledExecutor") ScheduledExecutorService jobTaskScheduledExecutor, Auth2Properties auth2Properties, MdcProperties mdcProperties, @Autowired(required=false) RefreshAccessTokenJobHandler refreshAccessTokenJobHandler) {
        this.jobTaskScheduledExecutor = jobTaskScheduledExecutor;
        this.auth2Properties = auth2Properties;
        this.mdcIdType = mdcProperties.getType();
        this.refreshAccessTokenJobHandler = refreshAccessTokenJobHandler;
    }

    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        taskRegistrar.setScheduler((Object)this.jobTaskScheduledExecutor);
        if (this.refreshAccessTokenJobHandler != null) {
            taskRegistrar.addCronTask(MdcUtil.decorateTasks(this.refreshAccessTokenJobHandler::refreshAccessTokenJob, this.mdcIdType, this.mdcIdGenerator), this.auth2Properties.getRefreshTokenJobCron());
        }
    }
}

