/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import java.time.LocalDateTime;
import top.dcenter.ums.security.core.oauth.enums.ErrorCodeEnum;

public class ResponseResult {
    private int code;
    private String msg;
    private Object data;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss", locale="zh", timezone="GMT+8")
    @JsonDeserialize(using=LocalDateTimeDeserializer.class)
    private LocalDateTime timestamp;

    public ResponseResult(int code, String msg) {
        this.code = code;
        this.msg = msg;
        this.data = null;
        this.timestamp = LocalDateTime.now();
    }

    public ResponseResult(int code) {
        this(code, null);
    }

    public static ResponseResult success() {
        return ResponseResult.success(null);
    }

    public static ResponseResult success(String msg) {
        return ResponseResult.success(msg, null);
    }

    public static ResponseResult success(String msg, Object data) {
        ResponseResult responseResult = new ResponseResult(0);
        responseResult.setMsg(msg);
        responseResult.setData(data);
        return responseResult;
    }

    public static ResponseResult fail(ErrorCodeEnum errorCodeEnum) {
        return ResponseResult.fail(errorCodeEnum, null);
    }

    public static ResponseResult fail(ErrorCodeEnum errorCodeEnum, Object data) {
        return new ResponseResult(errorCodeEnum.getCode(), errorCodeEnum.getMsg(), data, LocalDateTime.now());
    }

    public static ResponseResult fail(String errorMsg, ErrorCodeEnum errorCodeEnum) {
        return new ResponseResult(errorCodeEnum.getCode(), errorMsg, null, LocalDateTime.now());
    }

    public static ResponseResult fail(String errorMsg, ErrorCodeEnum errorCodeEnum, Object data) {
        return new ResponseResult(errorCodeEnum.getCode(), errorMsg, data, LocalDateTime.now());
    }

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public Object getData() {
        return this.data;
    }

    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public void setTimestamp(LocalDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public ResponseResult(int code, String msg, Object data, LocalDateTime timestamp) {
        this.code = code;
        this.msg = msg;
        this.data = data;
        this.timestamp = timestamp;
    }
}

