/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.mdc;

import me.zhyd.oauth.utils.UuidUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import top.dcenter.ums.security.core.mdc.MdcIdGenerator;

public enum MdcIdType implements MdcIdGenerator
{
    UUID{

        @Override
        public String getMdcId() {
            return UuidUtils.getUUID();
        }
    }
    ,
    THREAD_ID{

        @Override
        public String getMdcId() {
            return Thread.currentThread().getId() + "";
        }
    }
    ,
    SESSION_ID{

        @Override
        public String getMdcId() {
            RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
            if (requestAttributes == null) {
                return UuidUtils.getUUID();
            }
            return requestAttributes.getSessionId();
        }
    }
    ,
    CUSTOMIZE_ID;

}

