/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.api.validate.code;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.social.connect.web.HttpSessionSessionStrategy;
import org.springframework.social.connect.web.SessionStrategy;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.ServletWebRequest;
import top.dcenter.ums.security.core.api.validate.code.ValidateCodeGenerator;
import top.dcenter.ums.security.core.api.validate.code.ValidateCodeProcessor;
import top.dcenter.ums.security.core.auth.validate.codes.ValidateCode;
import top.dcenter.ums.security.core.enums.ErrorCodeEnum;
import top.dcenter.ums.security.core.enums.ValidateCodeType;
import top.dcenter.ums.security.core.exception.ValidateCodeException;

public abstract class AbstractValidateCodeProcessor
implements ValidateCodeProcessor {
    private static final Logger log = LoggerFactory.getLogger(AbstractValidateCodeProcessor.class);
    protected final SessionStrategy sessionStrategy = new HttpSessionSessionStrategy();
    protected final Map<String, ValidateCodeGenerator<?>> validateCodeGenerators;

    public AbstractValidateCodeProcessor(Map<String, ValidateCodeGenerator<?>> validateCodeGenerators) {
        if (validateCodeGenerators == null) {
            this.validateCodeGenerators = new HashMap(0);
            return;
        }
        Collection<ValidateCodeGenerator<?>> values = validateCodeGenerators.values();
        this.validateCodeGenerators = values.stream().collect(Collectors.toMap(ValidateCodeGenerator::getValidateCodeType, validateCodeGenerator -> validateCodeGenerator));
    }

    @Override
    public final boolean produce(ServletWebRequest request) throws ValidateCodeException {
        HttpServletRequest req = request.getRequest();
        String ip = req.getRemoteAddr();
        String sid = request.getSessionId();
        String uri = req.getRequestURI();
        try {
            ValidateCode validateCode = this.generate(request);
            this.saveSession(request, validateCode);
            boolean validateStatus = this.sent(request, validateCode);
            if (!validateStatus) {
                this.sessionStrategy.removeAttribute((RequestAttributes)request, this.getValidateCodeType().getSessionKey());
                log.warn("\u53d1\u9001\u9a8c\u8bc1\u7801\u5931\u8d25: ip={}, sid={}, uri={}, validateCode={}", new Object[]{ip, sid, uri, validateCode.toString()});
                return false;
            }
        }
        catch (Exception e) {
            this.sessionStrategy.removeAttribute((RequestAttributes)request, this.getValidateCodeType().getSessionKey());
            if (e instanceof ValidateCodeException) {
                ValidateCodeException exception = (ValidateCodeException)((Object)e);
                log.warn(String.format("\u751f\u6210\u9a8c\u8bc1\u7801\u5931\u8d25: error={}, ip={}, uid={}, sid={}, uri={}, data={}", exception.getMessage(), ip, exception.getUid(), sid, uri, exception.getData()), (Throwable)((Object)exception));
                throw exception;
            }
            log.warn(String.format("\u751f\u6210\u9a8c\u8bc1\u7801\u5931\u8d25: error={}, ip={}, sid={}, uri={}", e.getMessage(), ip, sid, uri), (Throwable)e);
            throw new ValidateCodeException(ErrorCodeEnum.GET_VALIDATE_CODE_FAILURE, (Throwable)e, ip, uri);
        }
        return true;
    }

    @Override
    public final ValidateCode generate(ServletWebRequest request) {
        try {
            ValidateCodeGenerator<?> validateCodeGenerator = this.getValidateCodeGenerator(this.getValidateCodeType());
            return (ValidateCode)validateCodeGenerator.generate((ServletRequest)request.getRequest());
        }
        catch (ValidateCodeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ValidateCodeException(ErrorCodeEnum.GET_VALIDATE_CODE_FAILURE, (Throwable)e, request.getRequest().getRemoteAddr(), request.getRequest().getRequestURI());
        }
    }

    @Override
    public boolean saveSession(ServletWebRequest request, ValidateCode validateCode) {
        try {
            ValidateCodeType validateCodeType = this.getValidateCodeType();
            if (validateCodeType == null) {
                return false;
            }
            this.sessionStrategy.setAttribute((RequestAttributes)request, validateCodeType.getSessionKey(), (Object)validateCode);
        }
        catch (Exception e) {
            log.error(String.format("\u9a8c\u8bc1\u7801\u4fdd\u5b58\u5230Session\u5931\u8d25: error={}, ip={}, code={}", e.getMessage(), request.getRequest().getRemoteAddr(), validateCode), (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public abstract boolean sent(ServletWebRequest var1, ValidateCode var2);

    @Override
    public void validate(ServletWebRequest request) throws ValidateCodeException {
        ValidateCodeType validateCodeType = this.getValidateCodeType();
        String sessionKey = validateCodeType.getSessionKey();
        String requestParamValidateCodeName = this.getValidateCodeGenerator(validateCodeType).getRequestParamValidateCodeName();
        ValidateCode codeInSession = (ValidateCode)this.sessionStrategy.getAttribute((RequestAttributes)request, sessionKey);
        String codeInRequest = request.getParameter(requestParamValidateCodeName).trim();
        HttpServletRequest req = request.getRequest();
        if (!StringUtils.isNotBlank((String)codeInRequest)) {
            throw new ValidateCodeException(ErrorCodeEnum.VALIDATE_CODE_NOT_EMPTY, req.getRemoteAddr(), validateCodeType.name());
        }
        if (codeInSession == null) {
            throw new ValidateCodeException(ErrorCodeEnum.VALIDATE_CODE_EXPIRED, req.getRemoteAddr(), codeInRequest);
        }
        if (codeInSession.isExpired()) {
            this.sessionStrategy.removeAttribute((RequestAttributes)request, sessionKey);
            throw new ValidateCodeException(ErrorCodeEnum.VALIDATE_CODE_EXPIRED, req.getRemoteAddr(), codeInRequest);
        }
        if (!StringUtils.equalsIgnoreCase((String)codeInSession.getCode(), (String)codeInRequest)) {
            throw new ValidateCodeException(ErrorCodeEnum.VALIDATE_CODE_ERROR, req.getRemoteAddr(), codeInRequest);
        }
        this.sessionStrategy.removeAttribute((RequestAttributes)request, sessionKey);
    }

    @Override
    public abstract ValidateCodeType getValidateCodeType();

    private ValidateCodeGenerator<?> getValidateCodeGenerator(ValidateCodeType type) throws ValidateCodeException {
        try {
            ValidateCodeGenerator<?> validateCodeGenerator;
            if (this.validateCodeGenerators != null && (validateCodeGenerator = this.validateCodeGenerators.get(type.name().toLowerCase())) != null) {
                return validateCodeGenerator;
            }
            throw new ValidateCodeException(ErrorCodeEnum.ILLEGAL_VALIDATE_CODE_TYPE, null, type.name());
        }
        catch (Exception e) {
            throw new ValidateCodeException(ErrorCodeEnum.ILLEGAL_VALIDATE_CODE_TYPE, (Throwable)e, null, type.name());
        }
    }
}

