/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.permission.filter;

import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.filter.OncePerRequestFilter;
import top.dcenter.ums.security.core.api.permission.service.UriAuthorizeService;
import top.dcenter.ums.security.core.permission.config.Repeat;
import top.dcenter.ums.security.core.permission.config.RestfulAPI;
import top.dcenter.ums.security.core.permission.enums.PermissionSuffixType;

public class UriAuthorizeFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(UriAuthorizeFilter.class);
    private final UriAuthorizeService uriAuthorizeService;
    @Autowired(required=false)
    private RestfulAPI restfulAPI;
    @Autowired(required=false)
    private Repeat repeat;
    private final Set<String> uriOfPermissionSet;
    private final AntPathMatcher matcher;

    public UriAuthorizeFilter(UriAuthorizeService uriAuthorizeService) {
        this.uriAuthorizeService = uriAuthorizeService;
        this.uriOfPermissionSet = ((Map)uriAuthorizeService.getUriAuthoritiesOfAllRole().orElse(new HashMap(0))).keySet();
        this.matcher = uriAuthorizeService.getAntPathMatcher();
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String requestURI = request.getRequestURI();
        if (this.uriAuthorizeService.isUriContainsInUriSet(this.uriOfPermissionSet, requestURI).booleanValue()) {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            Map uriAuthorityOfUserRoleMap = this.uriAuthorizeService.getUriAuthoritiesOfUserRole(authentication).orElse(new HashMap(0));
            Object principal = authentication.getPrincipal();
            String sid = request.getSession(true).getId();
            String ip = request.getRemoteAddr();
            String uri = request.getRequestURI();
            long now = Instant.now().toEpochMilli();
            String referer = request.getHeader("referer");
            String userAgent = request.getHeader("User-Agent");
            String method = request.getMethod();
            if (this.uriAuthorizeService.isUriContainsInUriSet(uriAuthorityOfUserRoleMap.keySet(), requestURI).booleanValue()) {
                HashSet uriAuthoritySet = new HashSet();
                for (Map.Entry next : uriAuthorityOfUserRoleMap.entrySet()) {
                    if (!this.matcher.match((String)next.getKey(), requestURI)) continue;
                    uriAuthoritySet.addAll((Collection)next.getValue());
                    if (this.repeat != null) continue;
                    break;
                }
                Set userAuthoritySet = authentication.getAuthorities().stream().map(grantedAuth -> grantedAuth.getAuthority()).flatMap(authorities -> Arrays.stream(StringUtils.splitByWholeSeparator((String)authorities, (String)","))).collect(Collectors.toSet());
                uriAuthoritySet.retainAll(userAuthoritySet);
                if (uriAuthoritySet.size() > 0) {
                    boolean hasPermission = true;
                    if (this.restfulAPI != null) {
                        hasPermission = uriAuthoritySet.stream().anyMatch(authority -> authority.endsWith(PermissionSuffixType.getPermissionSuffix(method)));
                    }
                    if (hasPermission) {
                        log.info("URI\u6743\u9650\u63a7\u5236-\u653e\u884c: sid={}, user={}, ip={}, uri={}, method={}, time={}, referer={}, agent={}", new Object[]{sid, principal, ip, uri, method, now, referer, userAgent});
                        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                        return;
                    }
                }
            }
            log.warn("URI\u6743\u9650\u63a7\u5236-\u7981\u6b62: sid={}, user={}, ip={}, uri={}, method={}, time={}, referer={}, agent={}", new Object[]{sid, principal, ip, uri, method, now, referer, userAgent});
            this.uriAuthorizeService.handlerError(HttpStatus.FORBIDDEN.value(), response);
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

