/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.sign;

import java.io.UnsupportedEncodingException;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.data.redis.connection.BitFieldSubCommands;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import top.dcenter.ums.security.core.api.sign.service.SignService;
import top.dcenter.ums.security.core.properties.SignProperties;
import top.dcenter.ums.security.core.util.SignUtil;

public class UserSignServiceImpl
implements SignService {
    private final RedisConnectionFactory redisConnectionFactory;
    private final SignProperties signProperties;

    public UserSignServiceImpl(RedisConnectionFactory redisConnectionFactory, SignProperties signProperties) {
        this.redisConnectionFactory = redisConnectionFactory;
        this.signProperties = signProperties;
    }

    public RedisConnection getConnection() {
        return this.redisConnectionFactory.getConnection();
    }

    private byte[] buildSignKey(String uid, LocalDate date) throws UnsupportedEncodingException {
        return (this.signProperties.getSignKeyPrefix() + SignUtil.buildSignKey(uid, date)).getBytes(this.signProperties.getCharset());
    }

    @Override
    public boolean doSign(String uid, LocalDate date) throws UnsupportedEncodingException {
        int offset = date.getDayOfMonth() - 1;
        try (RedisConnection connection = this.getConnection();){
            Boolean isSet = connection.setBit(this.buildSignKey(uid, date), (long)offset, true);
            boolean bl = Optional.ofNullable(isSet).orElse(false);
            return bl;
        }
    }

    @Override
    public boolean checkSign(String uid, LocalDate date) throws UnsupportedEncodingException {
        int offset = date.getDayOfMonth() - 1;
        try (RedisConnection connection = this.getConnection();){
            Boolean isSign = connection.getBit(this.buildSignKey(uid, date), (long)offset);
            boolean bl = Optional.ofNullable(isSign).orElse(false);
            return bl;
        }
    }

    @Override
    public long getSignCount(String uid, LocalDate date) throws UnsupportedEncodingException {
        try (RedisConnection connection = this.getConnection();){
            Long success = connection.bitCount(this.buildSignKey(uid, date));
            long l = Optional.ofNullable(success).orElse(0L);
            return l;
        }
    }

    @Override
    public long getContinuousSignCount(String uid, LocalDate date) throws UnsupportedEncodingException {
        int signCount = 0;
        List list = null;
        try (RedisConnection connection = this.getConnection();){
            BitFieldSubCommands subCommands = BitFieldSubCommands.create().get(BitFieldSubCommands.BitFieldType.unsigned((int)date.getDayOfMonth())).valueAt(0L);
            list = connection.bitField(this.buildSignKey(uid, date), subCommands);
        }
        if (list != null && list.size() > 0) {
            long v = list.get(0) == null ? 0L : (Long)list.get(0);
            for (int i = 0; i < date.getDayOfMonth(); ++i) {
                if (v >> 1 << 1 == v) {
                    if (i > 0) {
                        break;
                    }
                } else {
                    ++signCount;
                }
                v >>= 1;
            }
        }
        return signCount;
    }

    @Override
    public LocalDate getFirstSignDate(String uid, LocalDate date) throws UnsupportedEncodingException {
        Long pos = -1L;
        try (RedisConnection connection = this.getConnection();){
            pos = connection.bitPos(this.buildSignKey(uid, date), true);
        }
        return pos != null && pos < 0L ? null : date.withDayOfMonth((int)(pos + 1L));
    }

    @Override
    public Map<String, Boolean> getSignInfo(String uid, LocalDate date) throws UnsupportedEncodingException {
        List list;
        HashMap<String, Boolean> signMap = new HashMap<String, Boolean>(date.getDayOfMonth());
        try (RedisConnection connection = this.getConnection();){
            BitFieldSubCommands subCommands = BitFieldSubCommands.create().get(BitFieldSubCommands.BitFieldType.unsigned((int)date.lengthOfMonth())).valueAt(0L);
            list = connection.bitField(this.buildSignKey(uid, date), subCommands);
        }
        this.fillingSignMap(date, signMap, date.lengthOfMonth(), 0, list);
        return signMap;
    }

    @Override
    public Map<String, Boolean> getSignInfoForTheLastFewDays(String uid, LocalDate date) throws UnsupportedEncodingException {
        int dayOfMonth = date.getDayOfMonth();
        int lastFewDays = this.signProperties.getLastFewDays();
        HashMap<String, Boolean> signMap = new HashMap<String, Boolean>(dayOfMonth);
        if (dayOfMonth >= lastFewDays) {
            this.fillingSignDetail2SignMap(lastFewDays, dayOfMonth - lastFewDays, uid, date, dayOfMonth, dayOfMonth - lastFewDays, signMap);
        } else {
            this.fillingSignDetail2SignMapOfCrossMonth(uid, date, dayOfMonth, lastFewDays, signMap);
        }
        return signMap;
    }

    private void fillingSignMap(LocalDate date, Map<String, Boolean> signMap, int lowDay, int beforeOfHighDay, List<Long> list) {
        if (list != null && list.size() > 0) {
            long v = list.get(0) == null ? 0L : list.get(0);
            for (int i = lowDay; i > beforeOfHighDay; --i) {
                LocalDate d = date.withDayOfMonth(i);
                signMap.put(SignUtil.formatDate(d, "yyyy-MM-dd"), v >> 1 << 1 != v);
                v >>= 1;
            }
        }
    }

    private void fillingSignDetail2SignMapOfCrossMonth(String uid, LocalDate date, int dayOfMonth, int lastFewDays, Map<String, Boolean> signMap) throws UnsupportedEncodingException {
        List preMonthList;
        List currentMonthList;
        LocalDate preMonthsDate = date.minusMonths(1L);
        int lengthOfPreMonth = preMonthsDate.lengthOfMonth();
        int remainingDays = lastFewDays - dayOfMonth;
        int currentMonthType = dayOfMonth;
        int currentMonthOffset = 0;
        int currentMonthLowDay = dayOfMonth;
        int currentMonthBeforeOfHighDay = 0;
        int preMonthType = remainingDays;
        int preMonthOffset = lengthOfPreMonth - remainingDays;
        int preMonthLowDay = lengthOfPreMonth;
        int preMonthBeforeOfHighDay = lengthOfPreMonth - remainingDays;
        try (RedisConnection connection = this.getConnection();){
            BitFieldSubCommands subCommands = BitFieldSubCommands.create().get(BitFieldSubCommands.BitFieldType.unsigned((int)currentMonthType)).valueAt((long)currentMonthOffset);
            currentMonthList = connection.bitField(this.buildSignKey(uid, date), subCommands);
            BitFieldSubCommands preMonthSubCommands = BitFieldSubCommands.create().get(BitFieldSubCommands.BitFieldType.unsigned((int)preMonthType)).valueAt((long)preMonthOffset);
            preMonthList = connection.bitField(this.buildSignKey(uid, preMonthsDate), preMonthSubCommands);
        }
        this.fillingSignMap(date, signMap, currentMonthLowDay, currentMonthBeforeOfHighDay, currentMonthList);
        this.fillingSignMap(preMonthsDate, signMap, preMonthLowDay, preMonthBeforeOfHighDay, preMonthList);
    }

    private void fillingSignDetail2SignMap(int type, int offset, String uid, LocalDate date, int lowDay, int beforeOfHighDay, Map<String, Boolean> signMap) throws UnsupportedEncodingException {
        List list;
        try (RedisConnection connection = this.getConnection();){
            BitFieldSubCommands subCommands = BitFieldSubCommands.create().get(BitFieldSubCommands.BitFieldType.unsigned((int)type)).valueAt((long)offset);
            list = connection.bitField(this.buildSignKey(uid, date), subCommands);
        }
        this.fillingSignMap(date, signMap, lowDay, beforeOfHighDay, list);
    }
}

