/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.core.session.SessionRegistryImpl;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.security.SpringSessionBackedSessionRegistry;
import top.dcenter.ums.security.core.api.authentication.handler.BaseAuthenticationFailureHandler;
import top.dcenter.ums.security.core.api.session.SessionEnhanceCheckService;
import top.dcenter.ums.security.core.api.session.strategy.DefaultRedirectInvalidSessionStrategy;
import top.dcenter.ums.security.core.api.session.strategy.EnhanceConcurrentControlAuthenticationStrategy;
import top.dcenter.ums.security.core.auth.controller.InvalidSessionController;
import top.dcenter.ums.security.core.auth.session.filter.SessionEnhanceCheckFilter;
import top.dcenter.ums.security.core.config.PropertiesAutoConfiguration;
import top.dcenter.ums.security.core.config.SecurityAutoConfiguration;
import top.dcenter.ums.security.core.properties.ClientProperties;
import top.dcenter.ums.security.core.util.HttpSecurityUtil;
import top.dcenter.ums.security.core.util.MvcUtil;

@Configuration
@AutoConfigureAfter(value={PropertiesAutoConfiguration.class, SecurityAutoConfiguration.class})
public class SecuritySessionAutoConfiguration
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(SecuritySessionAutoConfiguration.class);
    private final ClientProperties clientProperties;
    @Autowired(required=false)
    private SessionEnhanceCheckService sessionEnhanceCheckService;
    @Autowired
    private FindByIndexNameSessionRepository<?> sessionRepository;
    @Autowired
    private GenericApplicationContext applicationContext;

    public SecuritySessionAutoConfiguration(ClientProperties clientProperties) {
        this.clientProperties = clientProperties;
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.auth.controller.InvalidSessionController"})
    public InvalidSessionController invalidSessionController(ObjectMapper objectMapper) {
        return new InvalidSessionController(this.clientProperties, objectMapper);
    }

    @Bean
    public SessionEnhanceCheckFilter sessionEnhanceCheckFilter(BaseAuthenticationFailureHandler baseAuthenticationFailureHandler) {
        return new SessionEnhanceCheckFilter(baseAuthenticationFailureHandler, this.sessionEnhanceCheckService);
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.api.session.strategy.DefaultRedirectInvalidSessionStrategy"})
    public DefaultRedirectInvalidSessionStrategy defaultRedirectInvalidSessionStrategy() {
        return new DefaultRedirectInvalidSessionStrategy(this.clientProperties.getSession().getInvalidSessionUrl());
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.api.session.strategy.EnhanceConcurrentControlAuthenticationStrategy"})
    public EnhanceConcurrentControlAuthenticationStrategy enhanceConcurrentControlAuthenticationStrategy(SessionRegistry sessionRegistry) throws Exception {
        if (this.applicationContext == null) {
            log.error("\u542f\u52a8\u5931\u8d25: {}", (Object)EnhanceConcurrentControlAuthenticationStrategy.class.getName());
            throw new Exception("\u542f\u52a8\u5931\u8d25: " + EnhanceConcurrentControlAuthenticationStrategy.class.getName());
        }
        EnhanceConcurrentControlAuthenticationStrategy enhanceConcurrentControlAuthenticationStrategy = new EnhanceConcurrentControlAuthenticationStrategy(this.sessionEnhanceCheckService, sessionRegistry, this.clientProperties);
        return enhanceConcurrentControlAuthenticationStrategy;
    }

    @Bean
    public SessionRegistry sessionRegistry(ApplicationContext applicationContext) {
        if (this.sessionRepository == null) {
            SessionRegistryImpl sessionRegistryImpl = new SessionRegistryImpl();
            HttpSecurityUtil.registerDelegateApplicationListener(applicationContext, sessionRegistryImpl);
            return sessionRegistryImpl;
        }
        return new SpringSessionBackedSessionRegistry(this.sessionRepository);
    }

    public void afterPropertiesSet() throws Exception {
        MvcUtil.registerController("invalidSessionController", this.applicationContext, InvalidSessionController.class);
    }
}

