/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.config;

import java.util.Map;
import java.util.Set;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.CsrfConfigurer;
import top.dcenter.ums.security.core.api.config.HttpSecurityAware;
import top.dcenter.ums.security.core.config.PropertiesAutoConfiguration;
import top.dcenter.ums.security.core.config.SecurityCsrfAutoConfiguration;
import top.dcenter.ums.security.core.properties.ClientProperties;

@Configuration
@AutoConfigureAfter(value={SecurityCsrfAutoConfiguration.class, PropertiesAutoConfiguration.class})
public class CsrfAutoConfigurerAware
implements HttpSecurityAware {
    private final ClientProperties clientProperties;

    public CsrfAutoConfigurerAware(ClientProperties clientProperties) {
        this.clientProperties = clientProperties;
    }

    @Override
    public void preConfigure(HttpSecurity http) throws Exception {
    }

    @Override
    public void postConfigure(HttpSecurity http) throws Exception {
        ClientProperties.CsrfProperties csrfProperties = this.clientProperties.getCsrf();
        if (csrfProperties.getCsrfIsOpen().booleanValue()) {
            CsrfConfigurer csrf = http.csrf();
            Set<String> ignoringAntMatcherUrls = csrfProperties.getIgnoringAntMatcherUrls();
            String[] urls = new String[ignoringAntMatcherUrls.size()];
            ignoringAntMatcherUrls.toArray(urls);
            csrf.ignoringAntMatchers(urls);
        } else {
            http.csrf().disable();
        }
    }

    @Override
    public Map<String, Map<String, Set<String>>> getAuthorizeRequestMap() {
        return null;
    }
}

