/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.api.permission.service;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.util.AntPathMatcher;
import top.dcenter.ums.security.core.api.permission.service.UriAuthorizeService;
import top.dcenter.ums.security.core.permission.dto.UriResourcesDTO;
import top.dcenter.ums.security.core.util.ConvertUtil;

public abstract class AbstractUriAuthorizeService
implements UriAuthorizeService,
InitializingBean {
    private static final String DEFAULT_ROLE_PREFIX = "ROLE_";
    public static final String PERMISSION_DELIMITER = ",";
    protected Map<String, Map<String, UriResourcesDTO>> rolesAuthorities;
    protected AntPathMatcher antPathMatcher = new AntPathMatcher();
    private final Object lock = new Object();

    @Override
    public boolean hasPermission(HttpServletRequest request, Authentication authentication, String uriAuthorize) {
        Map uriAuthorityMap = this.getUriAuthoritiesOfUserRole(authentication).orElse(new HashMap(0));
        String requestUri = request.getRequestURI();
        Set<String> uriSet = uriAuthorityMap.keySet();
        if (this.isUriContainsInUriSet(uriSet, requestUri).booleanValue()) {
            return uriAuthorityMap.values().stream().anyMatch(authoritySet -> authoritySet.contains(uriAuthorize));
        }
        return false;
    }

    @Override
    public Optional<Map<String, Set<String>>> getUriAuthoritiesOfUserRole(Authentication authentication) {
        if (authentication == null) {
            return Optional.of(Collections.emptyMap());
        }
        Set authoritySet = AuthorityUtils.authorityListToSet((Collection)authentication.getAuthorities());
        Set roleSet = authoritySet.stream().map(authorities -> StringUtils.splitByWholeSeparator((String)authorities, (String)PERMISSION_DELIMITER)).flatMap(Arrays::stream).filter(authority -> authority.startsWith(DEFAULT_ROLE_PREFIX)).collect(Collectors.toSet());
        HashMap<String, Set<String>> uriAuthoritiesMap = new HashMap<String, Set<String>>(this.rolesAuthorities.size());
        this.rolesAuthorities.entrySet().stream().filter(map -> roleSet.contains(map.getKey())).map(Map.Entry::getValue).forEach(this.map2mapConsumer(uriAuthoritiesMap));
        return Optional.of(uriAuthoritiesMap);
    }

    @Override
    public Optional<Map<String, Set<String>>> getUriAuthoritiesOfAllRole() {
        HashMap<String, Set<String>> uriAuthoritiesMap = new HashMap<String, Set<String>>(this.rolesAuthorities.size());
        this.rolesAuthorities.values().forEach(this.map2mapConsumer(uriAuthoritiesMap));
        return Optional.of(uriAuthoritiesMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRolesAuthorities() {
        Object object = this.lock;
        synchronized (object) {
            this.rolesAuthorities = this.getRolesAuthorities().orElse(new HashMap(0));
        }
    }

    @Override
    public Boolean isUriContainsInUriSet(Set<String> uriSet, String requestUri) {
        return uriSet.contains(requestUri) || uriSet.stream().anyMatch(uri -> this.antPathMatcher.match(uri, requestUri));
    }

    public void afterPropertiesSet() {
        this.updateRolesAuthorities();
    }

    @SuppressFBWarnings(value={"NP_NONNULL_RETURN_VIOLATION"})
    @NotNull
    private Consumer<Map<String, UriResourcesDTO>> map2mapConsumer(Map<String, Set<String>> uriAuthoritiesMap) {
        return map -> map.forEach((key, value) -> uriAuthoritiesMap.compute((String)key, (k, v) -> {
            if (v == null) {
                v = new HashSet<String>();
            }
            v.addAll(ConvertUtil.string2Set(value.getPermission(), PERMISSION_DELIMITER));
            return v;
        }));
    }

    @Override
    public AntPathMatcher getAntPathMatcher() {
        return this.antPathMatcher;
    }
}

