/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.validate.codes.sms;

import java.util.Map;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.context.request.ServletWebRequest;
import top.dcenter.ums.security.core.api.validate.code.AbstractValidateCodeProcessor;
import top.dcenter.ums.security.core.api.validate.code.SmsCodeSender;
import top.dcenter.ums.security.core.api.validate.code.ValidateCodeGenerator;
import top.dcenter.ums.security.core.auth.validate.codes.ValidateCode;
import top.dcenter.ums.security.core.enums.ErrorCodeEnum;
import top.dcenter.ums.security.core.enums.ValidateCodeType;
import top.dcenter.ums.security.core.exception.ValidateCodeParamErrorException;
import top.dcenter.ums.security.core.properties.ValidateCodeProperties;

public class SmsValidateCodeProcessor
extends AbstractValidateCodeProcessor {
    private static final Logger log = LoggerFactory.getLogger(SmsValidateCodeProcessor.class);
    @Autowired
    protected SmsCodeSender smsCodeSender;
    @Autowired
    protected ValidateCodeProperties validateCodeProperties;

    public SmsValidateCodeProcessor(Map<String, ValidateCodeGenerator<?>> validateCodeGenerators) {
        super(validateCodeGenerators);
    }

    @Override
    public boolean sent(ServletWebRequest request, ValidateCode validateCode) {
        String mobile = null;
        HttpServletRequest req = request.getRequest();
        String ip = req.getRemoteAddr();
        String sid = request.getSessionId();
        String uri = req.getRequestURI();
        try {
            mobile = ServletRequestUtils.getRequiredStringParameter((ServletRequest)req, (String)this.validateCodeProperties.getSms().getRequestParamMobileName());
            if (StringUtils.isNotBlank((String)mobile) && mobile.matches("1\\d{10}")) {
                return this.smsCodeSender.sendSms(mobile, validateCode.getCode());
            }
        }
        catch (ServletRequestBindingException e) {
            log.error(String.format("\u53d1\u9001\u9a8c\u8bc1\u7801\u5931\u8d25-\u624b\u673a\u53f7\u53c2\u6570\u9519\u8bef: error={}, ip={}, sid={}, uri={}, validateCode={}", e.getMessage(), ip, sid, uri, validateCode.toString()), (Throwable)e);
            throw new ValidateCodeParamErrorException(ErrorCodeEnum.MOBILE_PARAMETER_ERROR, this.validateCodeProperties.getSms().getRequestParamMobileName(), ip);
        }
        catch (PatternSyntaxException e) {
            log.error(String.format("\u53d1\u9001\u9a8c\u8bc1\u7801\u5931\u8d25-\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e: error={}, ip={}, sid={}, uri={}, validateCode={}", e.getMessage(), ip, sid, uri, validateCode.toString()), (Throwable)e);
        }
        throw new ValidateCodeParamErrorException(ErrorCodeEnum.MOBILE_FORMAT_ERROR, mobile, ip);
    }

    @Override
    public ValidateCodeType getValidateCodeType() {
        return ValidateCodeType.SMS;
    }
}

