/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.permission.enums;

import java.util.Objects;

public enum PermissionSuffixType {
    LIST("GET"){

        @Override
        public String getPermissionSuffix() {
            return ":list";
        }
    }
    ,
    ADD("POST"){

        @Override
        public String getPermissionSuffix() {
            return ":add";
        }
    }
    ,
    EDIT("PUT"){

        @Override
        public String getPermissionSuffix() {
            return ":edit";
        }
    }
    ,
    DELETE("DELETE"){

        @Override
        public String getPermissionSuffix() {
            return ":del";
        }
    };

    private String method;

    private PermissionSuffixType(String method) {
        this.method = method;
    }

    public abstract String getPermissionSuffix();

    public static String getPermissionSuffix(String method) {
        Objects.requireNonNull(method, "method require non null");
        PermissionSuffixType[] types = PermissionSuffixType.values();
        int length = types.length;
        for (int i = 0; i < length; ++i) {
            if (!types[i].method.equals(method.toUpperCase())) continue;
            return types[i].getPermissionSuffix();
        }
        return null;
    }

    public String getMethod() {
        return this.method;
    }
}

