/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.RedirectStrategy;
import top.dcenter.ums.security.core.enums.ErrorCodeEnum;
import top.dcenter.ums.security.core.enums.LoginProcessType;
import top.dcenter.ums.security.core.exception.AbstractResponseJsonAuthenticationException;
import top.dcenter.ums.security.core.properties.ClientProperties;
import top.dcenter.ums.security.core.vo.ResponseResult;

public class AuthenticationUtil {
    public static final String EXTRACT_USER_AGENT_REGEX = "[\\.|\\d|\\s|\\(|\\)]";

    public static AbstractResponseJsonAuthenticationException getAbstractResponseJsonAuthenticationException(AuthenticationException exception) {
        AbstractResponseJsonAuthenticationException e = null;
        if (exception instanceof AbstractResponseJsonAuthenticationException) {
            e = (AbstractResponseJsonAuthenticationException)exception;
        }
        return e;
    }

    public static boolean authenticationFailureProcessing(HttpServletResponse response, AuthenticationException exception, AbstractResponseJsonAuthenticationException e, String acceptHeader, ObjectMapper objectMapper, ClientProperties clientProperties) throws IOException {
        boolean isAcceptHeader;
        boolean isJsonProcessType = LoginProcessType.JSON.equals((Object)clientProperties.getLoginProcessType());
        boolean bl = isAcceptHeader = StringUtils.isNotBlank((String)acceptHeader) && (acceptHeader.contains("application/x-www-form-urlencoded") || acceptHeader.contains("application/json"));
        if (isJsonProcessType || isAcceptHeader) {
            ResponseResult result;
            int status = HttpStatus.UNAUTHORIZED.value();
            if (e != null) {
                status = e.getErrorCodeEnum().getCode();
                result = ResponseResult.fail(e.getErrorCodeEnum(), e.getData());
            } else {
                result = ResponseResult.fail(exception.getMessage(), ErrorCodeEnum.UNAUTHORIZED);
            }
            AuthenticationUtil.responseWithJson(response, status, objectMapper.writeValueAsString((Object)result));
            return true;
        }
        return false;
    }

    public static void responseWithJson(HttpServletResponse response, int status, String result) throws IOException {
        response.setStatus(status);
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        PrintWriter writer = response.getWriter();
        writer.write(result);
        writer.flush();
    }

    public static String extractUserAgent(String userAgent) {
        return userAgent.replaceAll(EXTRACT_USER_AGENT_REGEX, "");
    }

    public static void redirectProcessingLogoutByLoginProcessType(HttpServletRequest request, HttpServletResponse response, ClientProperties clientProperties, ObjectMapper objectMapper, RedirectStrategy redirectStrategy, ErrorCodeEnum errorCodeEnum) throws IOException {
        AuthenticationUtil.redirectProcessing(request, response, clientProperties, objectMapper, redirectStrategy, errorCodeEnum, clientProperties.getLogoutSuccessUrl());
    }

    public static void redirectProcessingByLoginProcessType(HttpServletRequest request, HttpServletResponse response, ClientProperties clientProperties, ObjectMapper objectMapper, RedirectStrategy redirectStrategy, ErrorCodeEnum errorCodeEnum, String redirectUrl) throws IOException {
        String referer = Objects.requireNonNullElse(request.getHeader("Referer"), redirectUrl);
        AuthenticationUtil.redirectProcessing(request, response, clientProperties, objectMapper, redirectStrategy, errorCodeEnum, referer);
    }

    private static void redirectProcessing(HttpServletRequest request, HttpServletResponse response, ClientProperties clientProperties, ObjectMapper objectMapper, RedirectStrategy redirectStrategy, ErrorCodeEnum errorCodeEnum, String redirectUrl) throws IOException {
        if (LoginProcessType.JSON.equals((Object)clientProperties.getLoginProcessType())) {
            int status = HttpStatus.UNAUTHORIZED.value();
            response.setStatus(status);
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            response.getWriter().write(objectMapper.writeValueAsString((Object)ResponseResult.fail(errorCodeEnum, redirectUrl)));
            return;
        }
        redirectStrategy.sendRedirect(request, response, redirectUrl);
    }
}

