/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.controller;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpStatus;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import top.dcenter.ums.security.core.enums.ErrorCodeEnum;
import top.dcenter.ums.security.core.exception.IllegalAccessUrlException;
import top.dcenter.ums.security.core.properties.ClientProperties;
import top.dcenter.ums.security.core.util.AuthenticationUtil;

@ResponseBody
public class InvalidSessionController {
    private static final Logger log = LoggerFactory.getLogger(InvalidSessionController.class);
    private final RedirectStrategy redirectStrategy;
    private final ClientProperties clientProperties;
    private final ObjectMapper objectMapper;

    public InvalidSessionController(ClientProperties clientProperties, ObjectMapper objectMapper) {
        this.clientProperties = clientProperties;
        this.objectMapper = objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.redirectStrategy = new DefaultRedirectStrategy();
    }

    @GetMapping(value={"/session/invalid"})
    @ResponseStatus(code=HttpStatus.UNAUTHORIZED)
    @ConditionalOnProperty(prefix="security.client", name={"invalid-session-url"}, havingValue="/session/invalid")
    public void invalidSessionHandler(HttpServletRequest request, HttpServletResponse response) {
        try {
            AuthenticationUtil.redirectProcessingByLoginProcessType(request, response, this.clientProperties, this.objectMapper, this.redirectStrategy, ErrorCodeEnum.INVALID_SESSION, this.clientProperties.getLoginPage());
        }
        catch (Exception e) {
            String requestUri = request.getRequestURI();
            String ip = request.getRemoteAddr();
            log.error(String.format("IllegalAccessUrlException: ip={}, uri={}, sid={}, error={}", ip, requestUri, request.getSession(true).getId(), e.getMessage()), (Throwable)e);
            throw new IllegalAccessUrlException(ErrorCodeEnum.SERVER_ERROR, requestUri, ip);
        }
    }
}

