/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.validate.codes;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.filter.OncePerRequestFilter;
import top.dcenter.ums.security.core.api.authentication.handler.BaseAuthenticationFailureHandler;
import top.dcenter.ums.security.core.api.validate.code.ValidateCodeProcessor;
import top.dcenter.ums.security.core.auth.validate.codes.ValidateCodeProcessorHolder;
import top.dcenter.ums.security.core.enums.ErrorCodeEnum;
import top.dcenter.ums.security.core.enums.ValidateCodeType;
import top.dcenter.ums.security.core.exception.AbstractResponseJsonAuthenticationException;
import top.dcenter.ums.security.core.exception.ValidateCodeException;
import top.dcenter.ums.security.core.properties.ValidateCodeProperties;
import top.dcenter.ums.security.core.util.ConvertUtil;

public class ValidateCodeFilter
extends OncePerRequestFilter
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(ValidateCodeFilter.class);
    private final ValidateCodeProperties validateCodeProperties;
    private final BaseAuthenticationFailureHandler baseAuthenticationFailureHandler;
    private final AntPathMatcher pathMatcher;
    private final ValidateCodeProcessorHolder validateCodeProcessorHolder;
    private Map<String, ValidateCodeType> authUrlMap = new HashMap<String, ValidateCodeType>();

    public ValidateCodeFilter(ValidateCodeProcessorHolder validateCodeProcessorHolder, BaseAuthenticationFailureHandler baseAuthenticationFailureHandler, ValidateCodeProperties validateCodeProperties) {
        this.baseAuthenticationFailureHandler = baseAuthenticationFailureHandler;
        this.pathMatcher = new AntPathMatcher();
        this.validateCodeProcessorHolder = validateCodeProcessorHolder;
        this.validateCodeProperties = validateCodeProperties;
    }

    public void afterPropertiesSet() throws ServletException {
        super.afterPropertiesSet();
        ConvertUtil.list2Map(this.validateCodeProperties.getImage().getAuthUrls(), ValidateCodeType.IMAGE, this.authUrlMap);
        ConvertUtil.list2Map(this.validateCodeProperties.getSms().getAuthUrls(), ValidateCodeType.SMS, this.authUrlMap);
    }

    protected void doFilterInternal(HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull FilterChain filterChain) throws ServletException, IOException {
        block3: {
            String requestUri = request.getRequestURI();
            ValidateCodeType validateCodeType = this.getValidateCodeType(request);
            String ip = request.getRemoteAddr();
            String sid = request.getSession(true).getId();
            try {
                if (validateCodeType == null) break block3;
                String typeName = validateCodeType.name();
                ValidateCodeProcessor validateCodeProcessor = this.validateCodeProcessorHolder.findValidateCodeProcessor(validateCodeType);
                if (validateCodeProcessor != null) {
                    validateCodeProcessor.validate(new ServletWebRequest(request, response));
                    break block3;
                }
                log.warn("\u8fdd\u6cd5\u7684\u6821\u9a8c\u7801\u7c7b\u578b: error={}, ip={}, sid={}, type={}", new Object[]{ErrorCodeEnum.ILLEGAL_VALIDATE_CODE_TYPE.getMsg(), ip, sid, typeName});
                throw new ValidateCodeException(ErrorCodeEnum.ILLEGAL_VALIDATE_CODE_TYPE, ip, typeName);
            }
            catch (Exception e) {
                log.warn("\u9a8c\u8bc1\u7801\u9519\u8bef: error={}, ip={}, sid={}, uri={}", new Object[]{e.getMessage(), ip, sid, requestUri});
                AbstractResponseJsonAuthenticationException ex = e instanceof AbstractResponseJsonAuthenticationException ? (AbstractResponseJsonAuthenticationException)((Object)e) : new ValidateCodeException(ErrorCodeEnum.VALIDATE_CODE_ERROR, (Throwable)e, ip, e.getMessage());
                this.baseAuthenticationFailureHandler.onAuthenticationFailure(request, response, ex);
                return;
            }
        }
        this.doFilter((ServletRequest)request, (ServletResponse)response, filterChain);
    }

    private ValidateCodeType getValidateCodeType(HttpServletRequest request) {
        String method = request.getMethod();
        if (!StringUtils.equalsIgnoreCase((String)method, (String)"GET")) {
            String requestUri = request.getRequestURI();
            ValidateCodeType result = this.authUrlMap.getOrDefault(requestUri, null);
            if (result != null) {
                return result;
            }
            for (Map.Entry<String, ValidateCodeType> next : this.authUrlMap.entrySet()) {
                if (!this.pathMatcher.match(next.getKey(), requestUri)) continue;
                return next.getValue();
            }
        }
        return null;
    }

    public Map<String, ValidateCodeType> getAuthUrlMap() {
        return this.authUrlMap;
    }

    public void setAuthUrlMap(Map<String, ValidateCodeType> authUrlMap) {
        this.authUrlMap = authUrlMap;
    }
}

