/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.validate.codes;

import java.io.Serializable;
import java.time.LocalDateTime;

public class ValidateCode
implements Serializable {
    private static final long serialVersionUID = 8564646192066649173L;
    private String code;
    private LocalDateTime expireTime;
    private String token;

    public ValidateCode(String code, int expireIn, String token) {
        this.code = code;
        this.expireTime = LocalDateTime.now().plusSeconds(expireIn);
        this.token = token;
    }

    public boolean isExpired() {
        return LocalDateTime.now().isAfter(this.expireTime);
    }

    public String getCode() {
        return this.code;
    }

    public LocalDateTime getExpireTime() {
        return this.expireTime;
    }

    public String getToken() {
        return this.token;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setExpireTime(LocalDateTime expireTime) {
        this.expireTime = expireTime;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String toString() {
        return "ValidateCode(code=" + this.getCode() + ", expireTime=" + this.getExpireTime() + ", token=" + this.getToken() + ")";
    }
}

