/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.validate.codes.image;

import javax.servlet.ServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.dcenter.ums.security.core.api.validate.code.ImageCodeFactory;
import top.dcenter.ums.security.core.api.validate.code.ValidateCodeGenerator;
import top.dcenter.ums.security.core.api.validate.code.ValidateCodeTokenFactory;
import top.dcenter.ums.security.core.auth.validate.codes.image.ImageCode;
import top.dcenter.ums.security.core.enums.ValidateCodeType;
import top.dcenter.ums.security.core.properties.ValidateCodeProperties;

public class ImageCodeGenerator
implements ValidateCodeGenerator<ImageCode> {
    private static final Logger log = LoggerFactory.getLogger(ImageCodeGenerator.class);
    protected final ValidateCodeProperties validateCodeProperties;
    protected final ImageCodeFactory imageCodeFactory;
    protected final ValidateCodeTokenFactory validateCodeTokenFactory;

    public ImageCodeGenerator(ValidateCodeProperties validateCodeProperties, ImageCodeFactory imageCodeFactory, ValidateCodeTokenFactory validateCodeTokenFactory) {
        this.validateCodeProperties = validateCodeProperties;
        this.imageCodeFactory = imageCodeFactory;
        this.validateCodeTokenFactory = validateCodeTokenFactory;
    }

    @Override
    public ImageCode generate(ServletRequest request) {
        return this.imageCodeFactory.getImageCode(request, this.validateCodeTokenFactory);
    }

    @Override
    public String getValidateCodeType() {
        return ValidateCodeType.IMAGE.name().toLowerCase();
    }

    @Override
    public String getRequestParamValidateCodeName() {
        return this.validateCodeProperties.getImage().getRequestParamImageCodeName();
    }
}

