/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.validate.codes.sms;

import javax.servlet.ServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.dcenter.ums.security.core.api.validate.code.SmsCodeSender;
import top.dcenter.ums.security.core.api.validate.code.ValidateCodeGenerator;
import top.dcenter.ums.security.core.api.validate.code.ValidateCodeTokenFactory;
import top.dcenter.ums.security.core.auth.validate.codes.ValidateCode;
import top.dcenter.ums.security.core.enums.ValidateCodeType;
import top.dcenter.ums.security.core.properties.ValidateCodeProperties;

public class SmsCodeGenerator
implements ValidateCodeGenerator<ValidateCode> {
    private static final Logger log = LoggerFactory.getLogger(SmsCodeGenerator.class);
    protected final ValidateCodeProperties validateCodeProperties;
    protected final SmsCodeSender smsCodeSender;
    protected final ValidateCodeTokenFactory validateCodeTokenFactory;

    public SmsCodeGenerator(ValidateCodeProperties validateCodeProperties, SmsCodeSender smsCodeSender, ValidateCodeTokenFactory validateCodeTokenFactory) {
        this.validateCodeProperties = validateCodeProperties;
        this.smsCodeSender = smsCodeSender;
        this.validateCodeTokenFactory = validateCodeTokenFactory;
    }

    @Override
    public ValidateCode generate(ServletRequest request) {
        return this.smsCodeSender.getCode(this.validateCodeTokenFactory);
    }

    @Override
    public String getValidateCodeType() {
        return ValidateCodeType.SMS.name().toLowerCase();
    }

    @Override
    public String getRequestParamValidateCodeName() {
        return this.validateCodeProperties.getSms().getRequestParamSmsCodeName();
    }
}

