/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.config;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.GenericApplicationContext;
import top.dcenter.ums.security.core.api.authentication.handler.BaseAuthenticationFailureHandler;
import top.dcenter.ums.security.core.api.validate.code.ImageCodeFactory;
import top.dcenter.ums.security.core.api.validate.code.SmsCodeSender;
import top.dcenter.ums.security.core.api.validate.code.ValidateCodeGenerator;
import top.dcenter.ums.security.core.api.validate.code.ValidateCodeTokenFactory;
import top.dcenter.ums.security.core.auth.controller.ValidateCodeController;
import top.dcenter.ums.security.core.auth.validate.codes.DefaultValidateCodeTokenFactory;
import top.dcenter.ums.security.core.auth.validate.codes.ValidateCodeFilter;
import top.dcenter.ums.security.core.auth.validate.codes.ValidateCodeProcessorHolder;
import top.dcenter.ums.security.core.auth.validate.codes.image.DefaultImageCodeFactory;
import top.dcenter.ums.security.core.auth.validate.codes.image.ImageCodeGenerator;
import top.dcenter.ums.security.core.auth.validate.codes.image.ImageValidateCodeProcessor;
import top.dcenter.ums.security.core.auth.validate.codes.sms.DefaultSmsCodeSender;
import top.dcenter.ums.security.core.auth.validate.codes.sms.SmsCodeGenerator;
import top.dcenter.ums.security.core.auth.validate.codes.sms.SmsValidateCodeProcessor;
import top.dcenter.ums.security.core.config.SecurityAutoConfiguration;
import top.dcenter.ums.security.core.properties.ValidateCodeProperties;
import top.dcenter.ums.security.core.util.MvcUtil;

@Configuration
@AutoConfigureAfter(value={SecurityAutoConfiguration.class})
public class ValidateCodeBeanAutoConfiguration
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(ValidateCodeBeanAutoConfiguration.class);
    @Autowired
    private GenericApplicationContext applicationContext;

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.api.validate.code.ValidateCodeTokenFactory"})
    public DefaultValidateCodeTokenFactory defaultValidateCodeTokenFactory() {
        return new DefaultValidateCodeTokenFactory();
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.auth.validate.codes.image.ImageCodeGenerator"})
    public ImageCodeGenerator imageCodeGenerator(ValidateCodeProperties validateCodeProperties, ValidateCodeTokenFactory validateCodeTokenFactory) {
        return new ImageCodeGenerator(validateCodeProperties, this.imageCodeFactory(validateCodeProperties), validateCodeTokenFactory);
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.auth.validate.codes.sms.SmsCodeGenerator"})
    public SmsCodeGenerator smsCodeGenerator(ValidateCodeProperties validateCodeProperties, SmsCodeSender smsCodeSender, ValidateCodeTokenFactory validateCodeTokenFactory) {
        return new SmsCodeGenerator(validateCodeProperties, smsCodeSender, validateCodeTokenFactory);
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.api.validate.code.SmsCodeSender"})
    public SmsCodeSender smsCodeSender(ValidateCodeProperties validateCodeProperties) {
        return new DefaultSmsCodeSender(validateCodeProperties);
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.security.core.validate.codes.ValidateCodeBeanAutoConfiguration.imageCodeFactory"})
    public ImageCodeFactory imageCodeFactory(ValidateCodeProperties validateCodeProperties) {
        return new DefaultImageCodeFactory(validateCodeProperties);
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.auth.validate.codes.image.ImageValidateCodeProcessor"})
    public ImageValidateCodeProcessor imageValidateCodeProcessor(Map<String, ValidateCodeGenerator<?>> validateCodeGenerators, ValidateCodeTokenFactory validateCodeTokenFactory) {
        return new ImageValidateCodeProcessor(validateCodeGenerators, validateCodeTokenFactory);
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.auth.validate.codes.sms.SmsValidateCodeProcessor"})
    public SmsValidateCodeProcessor smsValidateCodeProcessor(Map<String, ValidateCodeGenerator<?>> validateCodeGenerators, ValidateCodeTokenFactory validateCodeTokenFactory) {
        return new SmsValidateCodeProcessor(validateCodeGenerators, validateCodeTokenFactory);
    }

    @Bean
    public ValidateCodeProcessorHolder validateCodeProcessorHolder() {
        return new ValidateCodeProcessorHolder();
    }

    @Bean
    public ValidateCodeController validateCodeController() {
        return new ValidateCodeController();
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.auth.validate.codes.ValidateCodeFilter"})
    public ValidateCodeFilter validateCodeFilter(ValidateCodeProcessorHolder validateCodeProcessorHolder, BaseAuthenticationFailureHandler baseAuthenticationFailureHandler, ValidateCodeProperties validateCodeProperties) {
        return new ValidateCodeFilter(validateCodeProcessorHolder, baseAuthenticationFailureHandler, validateCodeProperties);
    }

    public void afterPropertiesSet() throws Exception {
        MvcUtil.registerController("validateCodeController", this.applicationContext, null);
    }
}

