/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.api.validate.code;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.context.request.ServletWebRequest;
import top.dcenter.ums.security.core.auth.validate.codes.ValidateCode;
import top.dcenter.ums.security.core.auth.validate.codes.ValidateCodeType;
import top.dcenter.ums.security.core.enums.ErrorCodeEnum;
import top.dcenter.ums.security.core.exception.ValidateCodeException;

public interface ValidateCodeGenerator<T> {
    public T generate(ServletRequest var1);

    public String getValidateCodeType();

    public String getRequestParamValidateCodeName();

    public void validate(ServletWebRequest var1) throws ValidateCodeException;

    default public void defaultValidate(ServletWebRequest request) throws ValidateCodeException {
        HttpServletRequest req = request.getRequest();
        ValidateCodeType validateCodeType = ValidateCodeType.valueOf(this.getValidateCodeType().toUpperCase());
        String sessionKey = validateCodeType.getSessionKey();
        HttpSession session = req.getSession();
        ValidateCode codeInSession = (ValidateCode)session.getAttribute(sessionKey);
        String requestParamValidateCodeName = this.getRequestParamValidateCodeName();
        String codeInRequest = request.getParameter(requestParamValidateCodeName);
        if (codeInSession == null) {
            throw new ValidateCodeException(ErrorCodeEnum.VALIDATE_CODE_EXPIRED, req.getRemoteAddr(), codeInRequest);
        }
        if (!StringUtils.isNotBlank((String)codeInRequest)) {
            session.removeAttribute(sessionKey);
            throw new ValidateCodeException(ErrorCodeEnum.VALIDATE_CODE_NOT_EMPTY, req.getRemoteAddr(), validateCodeType.name());
        }
        codeInRequest = codeInRequest.trim();
        if (codeInSession.isExpired()) {
            session.removeAttribute(sessionKey);
            throw new ValidateCodeException(ErrorCodeEnum.VALIDATE_CODE_EXPIRED, req.getRemoteAddr(), codeInRequest);
        }
        if (!StringUtils.equalsIgnoreCase((String)codeInSession.getCode(), (String)codeInRequest)) {
            if (!codeInSession.getReuse().booleanValue()) {
                session.removeAttribute(sessionKey);
            }
            throw new ValidateCodeException(ErrorCodeEnum.VALIDATE_CODE_ERROR, req.getRemoteAddr(), codeInRequest);
        }
        session.removeAttribute(sessionKey);
    }
}

