/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.handler;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.AuthenticationException;
import top.dcenter.ums.security.core.api.authentication.handler.BaseAuthenticationFailureHandler;
import top.dcenter.ums.security.core.auth.filter.AjaxOrFormRequestFilter;
import top.dcenter.ums.security.core.exception.AbstractResponseJsonAuthenticationException;
import top.dcenter.ums.security.core.properties.ClientProperties;
import top.dcenter.ums.security.core.util.AuthenticationUtil;

public class ClientAuthenticationFailureHandler
extends BaseAuthenticationFailureHandler {
    private static final Logger log = LoggerFactory.getLogger(ClientAuthenticationFailureHandler.class);
    protected final ObjectMapper objectMapper;
    protected final ClientProperties clientProperties;

    public ClientAuthenticationFailureHandler(ObjectMapper objectMapper, ClientProperties clientProperties) {
        this.objectMapper = objectMapper;
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.clientProperties = clientProperties;
        this.setDefaultFailureUrl(clientProperties.getFailureUrl());
    }

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        String reqData;
        AbstractResponseJsonAuthenticationException e = AuthenticationUtil.getAbstractResponseJsonAuthenticationException(exception);
        if (request instanceof AjaxOrFormRequestFilter.AjaxOrFormRequest) {
            AjaxOrFormRequestFilter.AjaxOrFormRequest ajaxOrFormRequest = (AjaxOrFormRequestFilter.AjaxOrFormRequest)request;
            reqData = new String(Objects.requireNonNullElse(ajaxOrFormRequest.getBody(), "".getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        } else {
            reqData = request.getParameterMap().toString();
        }
        log.info("\u767b\u5f55\u5931\u8d25: user={}, ip={}, ua={}, sid={}, reqData={}", new Object[]{e == null ? null : e.getUid(), request.getRemoteAddr(), request.getHeader("User-Agent"), request.getSession(true).getId(), reqData});
        String acceptHeader = request.getHeader("accept");
        if (AuthenticationUtil.authenticationFailureProcessing(response, exception, e, acceptHeader, this.objectMapper, this.clientProperties)) {
            return;
        }
        super.onAuthenticationFailure(request, response, exception);
    }
}

