/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Field;
import java.util.Objects;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.context.AnnotationConfigServletWebServerApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.web.context.support.GenericWebApplicationContext;
import org.springframework.web.util.UrlPathHelper;
import top.dcenter.ums.security.core.api.advice.SecurityControllerExceptionHandler;
import top.dcenter.ums.security.core.api.authentication.handler.BaseAuthenticationFailureHandler;
import top.dcenter.ums.security.core.api.authentication.handler.BaseAuthenticationSuccessHandler;
import top.dcenter.ums.security.core.api.controller.BaseSecurityController;
import top.dcenter.ums.security.core.api.logout.DefaultLogoutSuccessHandler;
import top.dcenter.ums.security.core.api.service.AbstractUserDetailsService;
import top.dcenter.ums.security.core.auth.controller.ClientSecurityController;
import top.dcenter.ums.security.core.auth.handler.ClientAuthenticationFailureHandler;
import top.dcenter.ums.security.core.auth.handler.ClientAuthenticationSuccessHandler;
import top.dcenter.ums.security.core.auth.provider.UsernamePasswordAuthenticationProvider;
import top.dcenter.ums.security.core.config.PropertiesAutoConfiguration;
import top.dcenter.ums.security.core.properties.ClientProperties;
import top.dcenter.ums.security.core.util.MvcUtil;

@Configuration
@AutoConfigureAfter(value={PropertiesAutoConfiguration.class})
public class SecurityAutoConfiguration
implements InitializingBean {
    private static final String URL_PATH_HELPER_BEAN_NAME = "mvcUrlPathHelper";
    private final ClientProperties clientProperties;
    private final ObjectMapper objectMapper;
    @Autowired
    private AbstractUserDetailsService abstractUserDetailsService;
    @Autowired
    private GenericApplicationContext applicationContext;

    public SecurityAutoConfiguration(ClientProperties clientProperties, ObjectMapper objectMapper) {
        this.clientProperties = clientProperties;
        this.objectMapper = objectMapper;
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.api.authentication.handler.BaseAuthenticationSuccessHandler"})
    public BaseAuthenticationSuccessHandler baseAuthenticationSuccessHandler() {
        return new ClientAuthenticationSuccessHandler(this.objectMapper, this.clientProperties);
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.api.authentication.handler.BaseAuthenticationFailureHandler"})
    public BaseAuthenticationFailureHandler baseAuthenticationFailureHandler() {
        return new ClientAuthenticationFailureHandler(this.objectMapper, this.clientProperties);
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.api.advice.SecurityControllerExceptionHandler"})
    public SecurityControllerExceptionHandler securityControllerExceptionHandler() {
        return new SecurityControllerExceptionHandler();
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.auth.provider.UsernamePasswordAuthenticationProvider"})
    public UsernamePasswordAuthenticationProvider usernamePasswordAuthenticationProvider(PasswordEncoder passwordEncoder) {
        return new UsernamePasswordAuthenticationProvider(passwordEncoder, this.abstractUserDetailsService);
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.api.logout.DefaultLogoutSuccessHandler"})
    public DefaultLogoutSuccessHandler defaultLogoutSuccessHandler() {
        return new DefaultLogoutSuccessHandler(this.clientProperties, this.objectMapper);
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.api.controller.BaseSecurityController"})
    @ConditionalOnProperty(prefix="security.client", name={"open-authentication-redirect"}, havingValue="true")
    public ClientSecurityController clientSecurityController() {
        return new ClientSecurityController(this.clientProperties);
    }

    public void afterPropertiesSet() throws Exception {
        Field[] declaredFields;
        if (this.clientProperties.getOpenAuthenticationRedirect().booleanValue()) {
            MvcUtil.registerController("clientSecurityController", this.applicationContext, BaseSecurityController.class);
        }
        Class<MvcUtil> mvcUtilClass = MvcUtil.class;
        Class.forName(mvcUtilClass.getName());
        for (Field field : declaredFields = mvcUtilClass.getDeclaredFields()) {
            field.setAccessible(true);
            if (Objects.equals(field.getName(), "servletContextPath")) {
                String contextPath;
                try {
                    contextPath = Objects.requireNonNull(((AnnotationConfigServletWebServerApplicationContext)this.applicationContext).getServletContext()).getContextPath();
                }
                catch (Exception e) {
                    contextPath = Objects.requireNonNull(((GenericWebApplicationContext)this.applicationContext).getServletContext()).getContextPath();
                }
                field.set(null, contextPath);
                continue;
            }
            if (!Objects.equals(field.getName(), "urlPathHelper")) continue;
            UrlPathHelper mvcUrlPathHelper = (UrlPathHelper)this.applicationContext.getBean(URL_PATH_HELPER_BEAN_NAME, UrlPathHelper.class);
            field.set(null, mvcUrlPathHelper);
        }
    }
}

