/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.permission.interceptor;

import java.time.Instant;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import top.dcenter.ums.security.core.api.permission.service.AbstractUriAuthorizeService;
import top.dcenter.ums.security.core.permission.annotation.UriAuthorize;
import top.dcenter.ums.security.core.util.MvcUtil;

public class UriAuthorizationAnnotationInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(UriAuthorizationAnnotationInterceptor.class);
    private AbstractUriAuthorizeService uriAuthorizeService;

    public UriAuthorizationAnnotationInterceptor(AbstractUriAuthorizeService uriAuthorizeService) {
        this.uriAuthorizeService = uriAuthorizeService;
    }

    public boolean preHandle(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull Object handler) throws Exception {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        UriAuthorize methodAnnotation = (UriAuthorize)((HandlerMethod)handler).getMethodAnnotation(UriAuthorize.class);
        if (methodAnnotation == null) {
            return true;
        }
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        boolean hasPermission = this.uriAuthorizeService.hasPermission(request, authentication, methodAnnotation.value());
        String sid = request.getSession(true).getId();
        Object principal = authentication.getPrincipal();
        String ip = request.getRemoteAddr();
        String uri = request.getRequestURI();
        long now = Instant.now().toEpochMilli();
        String referer = request.getHeader("referer");
        String userAgent = request.getHeader("User-Agent");
        String method = request.getMethod();
        if (hasPermission) {
            log.info("URI\u6743\u9650\u63a7\u5236-\u653e\u884c: sid={}, user={}, ip={}, uri={}, method={}, time={}, referer={}, agent={}", new Object[]{sid, principal, ip, MvcUtil.getServletContextPath() + uri, method, now, referer, userAgent});
            return true;
        }
        log.warn("URI\u6743\u9650\u63a7\u5236-\u7981\u6b62: sid={}, user={}, ip={}, uri={}, method={}, time={}, referer={}, agent={}", new Object[]{sid, principal, ip, MvcUtil.getServletContextPath() + uri, method, now, referer, userAgent});
        this.uriAuthorizeService.handlerError(HttpStatus.FORBIDDEN.value(), response);
        return false;
    }
}

