/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.properties;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.security.config.http.SessionCreationPolicy;
import top.dcenter.ums.security.core.enums.CsrfTokenRepositoryType;
import top.dcenter.ums.security.core.enums.LoginProcessType;

@ConfigurationProperties(value="security.client")
public class ClientProperties {
    @NestedConfigurationProperty
    private final SessionProperties session = new SessionProperties();
    @NestedConfigurationProperty
    private final RememberMeProperties rememberMe = new RememberMeProperties();
    @NestedConfigurationProperty
    private final CsrfProperties csrf = new CsrfProperties();
    @NestedConfigurationProperty
    private final AnonymousProperties anonymous = new AnonymousProperties();
    private String loginPage = "/login";
    private String loginProcessingUrl = "/authentication/form";
    private String failureUrl = this.loginPage;
    private String errorUrl = "/error";
    private String error4Url = "/4*.html";
    private String error5Url = "/5*.html";
    private String successUrl = "/";
    private String[] ignoringUrls;
    private Set<String> permitUrls = new HashSet<String>();
    private Boolean openAuthenticationRedirect = false;
    private String loginUnAuthenticationUrl = "/authentication/require";
    private List<String> authRedirectSuffixCondition;
    private LoginProcessType loginProcessType = LoginProcessType.JSON;
    public String logoutUrl = "/logout";
    public String logoutSuccessUrl = "/login";
    public String targetUrlParameter = "redirectTargetUrl";
    public String usernameParameter = "username";
    public String passwordParameter = "password";
    public Boolean useReferer = Boolean.TRUE;
    public Boolean sameOrigin = Boolean.FALSE;

    public ClientProperties() {
        this.authRedirectSuffixCondition = new ArrayList<String>();
    }

    public String getQueryRememberMeTableExistSql(String databaseName) {
        return "SELECT COUNT(1) FROM information_schema.tables WHERE table_schema='" + databaseName + "' AND table_name = 'persistent_logins'";
    }

    public SessionProperties getSession() {
        return this.session;
    }

    public RememberMeProperties getRememberMe() {
        return this.rememberMe;
    }

    public CsrfProperties getCsrf() {
        return this.csrf;
    }

    public AnonymousProperties getAnonymous() {
        return this.anonymous;
    }

    public String getLoginPage() {
        return this.loginPage;
    }

    public String getLoginProcessingUrl() {
        return this.loginProcessingUrl;
    }

    public String getFailureUrl() {
        return this.failureUrl;
    }

    public String getErrorUrl() {
        return this.errorUrl;
    }

    public String getError4Url() {
        return this.error4Url;
    }

    public String getError5Url() {
        return this.error5Url;
    }

    public String getSuccessUrl() {
        return this.successUrl;
    }

    public String[] getIgnoringUrls() {
        return this.ignoringUrls;
    }

    public Set<String> getPermitUrls() {
        return this.permitUrls;
    }

    public Boolean getOpenAuthenticationRedirect() {
        return this.openAuthenticationRedirect;
    }

    public String getLoginUnAuthenticationUrl() {
        return this.loginUnAuthenticationUrl;
    }

    public List<String> getAuthRedirectSuffixCondition() {
        return this.authRedirectSuffixCondition;
    }

    public LoginProcessType getLoginProcessType() {
        return this.loginProcessType;
    }

    public String getLogoutUrl() {
        return this.logoutUrl;
    }

    public String getLogoutSuccessUrl() {
        return this.logoutSuccessUrl;
    }

    public String getTargetUrlParameter() {
        return this.targetUrlParameter;
    }

    public String getUsernameParameter() {
        return this.usernameParameter;
    }

    public String getPasswordParameter() {
        return this.passwordParameter;
    }

    public Boolean getUseReferer() {
        return this.useReferer;
    }

    public Boolean getSameOrigin() {
        return this.sameOrigin;
    }

    public void setLoginPage(String loginPage) {
        this.loginPage = loginPage;
    }

    public void setLoginProcessingUrl(String loginProcessingUrl) {
        this.loginProcessingUrl = loginProcessingUrl;
    }

    public void setFailureUrl(String failureUrl) {
        this.failureUrl = failureUrl;
    }

    public void setErrorUrl(String errorUrl) {
        this.errorUrl = errorUrl;
    }

    public void setError4Url(String error4Url) {
        this.error4Url = error4Url;
    }

    public void setError5Url(String error5Url) {
        this.error5Url = error5Url;
    }

    public void setSuccessUrl(String successUrl) {
        this.successUrl = successUrl;
    }

    public void setIgnoringUrls(String[] ignoringUrls) {
        this.ignoringUrls = ignoringUrls;
    }

    public void setPermitUrls(Set<String> permitUrls) {
        this.permitUrls = permitUrls;
    }

    public void setOpenAuthenticationRedirect(Boolean openAuthenticationRedirect) {
        this.openAuthenticationRedirect = openAuthenticationRedirect;
    }

    public void setLoginUnAuthenticationUrl(String loginUnAuthenticationUrl) {
        this.loginUnAuthenticationUrl = loginUnAuthenticationUrl;
    }

    public void setAuthRedirectSuffixCondition(List<String> authRedirectSuffixCondition) {
        this.authRedirectSuffixCondition = authRedirectSuffixCondition;
    }

    public void setLoginProcessType(LoginProcessType loginProcessType) {
        this.loginProcessType = loginProcessType;
    }

    public void setLogoutUrl(String logoutUrl) {
        this.logoutUrl = logoutUrl;
    }

    public void setLogoutSuccessUrl(String logoutSuccessUrl) {
        this.logoutSuccessUrl = logoutSuccessUrl;
    }

    public void setTargetUrlParameter(String targetUrlParameter) {
        this.targetUrlParameter = targetUrlParameter;
    }

    public void setUsernameParameter(String usernameParameter) {
        this.usernameParameter = usernameParameter;
    }

    public void setPasswordParameter(String passwordParameter) {
        this.passwordParameter = passwordParameter;
    }

    public void setUseReferer(Boolean useReferer) {
        this.useReferer = useReferer;
    }

    public void setSameOrigin(Boolean sameOrigin) {
        this.sameOrigin = sameOrigin;
    }

    public static class AnonymousProperties {
        private Boolean anonymousIsOpen = true;
        private String principal = "ANONYMOUS";
        private List<String> authorities = new ArrayList<String>(List.of("ROLE_ANONYMOUS"));

        public Boolean getAnonymousIsOpen() {
            return this.anonymousIsOpen;
        }

        public String getPrincipal() {
            return this.principal;
        }

        public List<String> getAuthorities() {
            return this.authorities;
        }

        public void setAnonymousIsOpen(Boolean anonymousIsOpen) {
            this.anonymousIsOpen = anonymousIsOpen;
        }

        public void setPrincipal(String principal) {
            this.principal = principal;
        }

        public void setAuthorities(List<String> authorities) {
            this.authorities = authorities;
        }
    }

    public static class CsrfProperties {
        private Boolean csrfIsOpen = false;
        private Set<String> ignoringAntMatcherUrls = new HashSet<String>();
        private CsrfTokenRepositoryType tokenRepositoryType = CsrfTokenRepositoryType.SESSION;

        public Boolean getCsrfIsOpen() {
            return this.csrfIsOpen;
        }

        public Set<String> getIgnoringAntMatcherUrls() {
            return this.ignoringAntMatcherUrls;
        }

        public CsrfTokenRepositoryType getTokenRepositoryType() {
            return this.tokenRepositoryType;
        }

        public void setCsrfIsOpen(Boolean csrfIsOpen) {
            this.csrfIsOpen = csrfIsOpen;
        }

        public void setIgnoringAntMatcherUrls(Set<String> ignoringAntMatcherUrls) {
            this.ignoringAntMatcherUrls = ignoringAntMatcherUrls;
        }

        public void setTokenRepositoryType(CsrfTokenRepositoryType tokenRepositoryType) {
            this.tokenRepositoryType = tokenRepositoryType;
        }
    }

    public static class RememberMeProperties {
        @DurationUnit(value=ChronoUnit.SECONDS)
        private Duration rememberMeTimeout = Duration.parse("P14D");
        private String rememberMeCookieName = "REMEMBER_ME";
        private String rememberMeParameter = "REMEMBER_ME";
        private Boolean useSecureCookie = false;

        public Duration getRememberMeTimeout() {
            return this.rememberMeTimeout;
        }

        public String getRememberMeCookieName() {
            return this.rememberMeCookieName;
        }

        public String getRememberMeParameter() {
            return this.rememberMeParameter;
        }

        public Boolean getUseSecureCookie() {
            return this.useSecureCookie;
        }

        public void setRememberMeTimeout(Duration rememberMeTimeout) {
            this.rememberMeTimeout = rememberMeTimeout;
        }

        public void setRememberMeCookieName(String rememberMeCookieName) {
            this.rememberMeCookieName = rememberMeCookieName;
        }

        public void setRememberMeParameter(String rememberMeParameter) {
            this.rememberMeParameter = rememberMeParameter;
        }

        public void setUseSecureCookie(Boolean useSecureCookie) {
            this.useSecureCookie = useSecureCookie;
        }
    }

    public static class SessionProperties {
        private Boolean sessionNumberControl = false;
        private int maximumSessions = 1;
        private Boolean maxSessionsPreventsLogin = false;
        private Boolean enableSessionUrlRewriting = false;
        private SessionCreationPolicy sessionCreationPolicy = SessionCreationPolicy.ALWAYS;
        private String invalidSessionUrl = "/session/invalid";
        private String invalidSessionOfConcurrentUrl = "/";
        private String sessionCookieName = "JSESSIONID";

        public Boolean getSessionNumberControl() {
            return this.sessionNumberControl;
        }

        public int getMaximumSessions() {
            return this.maximumSessions;
        }

        public Boolean getMaxSessionsPreventsLogin() {
            return this.maxSessionsPreventsLogin;
        }

        public Boolean getEnableSessionUrlRewriting() {
            return this.enableSessionUrlRewriting;
        }

        public SessionCreationPolicy getSessionCreationPolicy() {
            return this.sessionCreationPolicy;
        }

        public String getInvalidSessionUrl() {
            return this.invalidSessionUrl;
        }

        public String getInvalidSessionOfConcurrentUrl() {
            return this.invalidSessionOfConcurrentUrl;
        }

        public String getSessionCookieName() {
            return this.sessionCookieName;
        }

        public void setSessionNumberControl(Boolean sessionNumberControl) {
            this.sessionNumberControl = sessionNumberControl;
        }

        public void setMaximumSessions(int maximumSessions) {
            this.maximumSessions = maximumSessions;
        }

        public void setMaxSessionsPreventsLogin(Boolean maxSessionsPreventsLogin) {
            this.maxSessionsPreventsLogin = maxSessionsPreventsLogin;
        }

        public void setEnableSessionUrlRewriting(Boolean enableSessionUrlRewriting) {
            this.enableSessionUrlRewriting = enableSessionUrlRewriting;
        }

        public void setSessionCreationPolicy(SessionCreationPolicy sessionCreationPolicy) {
            this.sessionCreationPolicy = sessionCreationPolicy;
        }

        public void setInvalidSessionUrl(String invalidSessionUrl) {
            this.invalidSessionUrl = invalidSessionUrl;
        }

        public void setInvalidSessionOfConcurrentUrl(String invalidSessionOfConcurrentUrl) {
            this.invalidSessionOfConcurrentUrl = invalidSessionOfConcurrentUrl;
        }

        public void setSessionCookieName(String sessionCookieName) {
            this.sessionCookieName = sessionCookieName;
        }
    }
}

