/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.util;

import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.util.UrlPathHelper;

public class MvcUtil {
    private static final Logger log = LoggerFactory.getLogger(MvcUtil.class);
    private static String servletContextPath = "";
    private static UrlPathHelper urlPathHelper = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UrlPathHelper getUrlPathHelper() {
        if (urlPathHelper != null) return urlPathHelper;
        Class<MvcUtil> clazz = MvcUtil.class;
        synchronized (MvcUtil.class) {
            if (urlPathHelper != null) return urlPathHelper;
            UrlPathHelper helper = new UrlPathHelper();
            helper.setAlwaysUseFullPath(true);
            urlPathHelper = helper;
            // ** MonitorExit[var0] (shouldn't be in output)
            return urlPathHelper;
        }
    }

    public static String getServletContextPath() {
        return servletContextPath;
    }

    private static void unregisterController(String controllerBeanName, GenericApplicationContext applicationContext) {
        RequestMappingHandlerMapping requestMappingHandlerMapping = (RequestMappingHandlerMapping)applicationContext.getBean("requestMappingHandlerMapping");
        Object controller = applicationContext.getBean(controllerBeanName);
        Class<?> targetClass = controller.getClass();
        ReflectionUtils.doWithMethods(targetClass, method -> {
            Method specificMethod = ClassUtils.getMostSpecificMethod((Method)method, (Class)targetClass);
            try {
                Method createMappingMethod = RequestMappingHandlerMapping.class.getDeclaredMethod("getMappingForMethod", Method.class, Class.class);
                createMappingMethod.setAccessible(true);
                RequestMappingInfo requestMappingInfo = (RequestMappingInfo)createMappingMethod.invoke((Object)requestMappingHandlerMapping, specificMethod, targetClass);
                if (requestMappingInfo != null) {
                    requestMappingHandlerMapping.unregisterMapping((Object)requestMappingInfo);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }, (ReflectionUtils.MethodFilter)ReflectionUtils.USER_DECLARED_METHODS);
    }

    public static void registerController(String controllerBeanName, GenericApplicationContext applicationContext, Class<?> clz) throws Exception {
        RequestMappingHandlerMapping requestMappingHandlerMapping = (RequestMappingHandlerMapping)applicationContext.getBean("requestMappingHandlerMapping");
        try {
            applicationContext.getBean(controllerBeanName);
        }
        catch (Exception e) {
            if (clz != null) {
                Object bean = applicationContext.getBean(clz);
                log.info("{} \u6ca1\u6709\u5728 IOC \u5bb9\u5668\u4e2d, \u5df2\u88ab {} \u66ff\u4ee3, \u65e0\u987b\u518d\u505a Uri \u6620\u5c04", (Object)controllerBeanName, (Object)bean.getClass().getName());
                return;
            }
            throw e;
        }
        MvcUtil.unregisterController(controllerBeanName, applicationContext);
        Method method = requestMappingHandlerMapping.getClass().getSuperclass().getSuperclass().getDeclaredMethod("detectHandlerMethods", Object.class);
        method.setAccessible(true);
        method.invoke((Object)requestMappingHandlerMapping, controllerBeanName);
        log.info("{} \u5728 mvc \u4e2d\u505a Uri \u6620\u5c04\u7b49\u52a8\u4f5c\u6210\u529f", (Object)controllerBeanName);
    }
}

