/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.util;

import java.util.Random;
import java.util.UUID;

public class ValidateCodeUtil {
    public static final String VERIFY_CODES = "23456789ABCDEFGHJKLMNPQRSTUVWXYZ";
    public static final String NUMBER_VERIFY_CODES = "0123456789";

    public static String getUUID() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static String generateVerifyCode(int verifySize) {
        return ValidateCodeUtil.generateVerifyCode(verifySize, VERIFY_CODES);
    }

    public static String generateNumberVerifyCode(int verifySize) {
        return ValidateCodeUtil.generateVerifyCode(verifySize, NUMBER_VERIFY_CODES);
    }

    public static String generateVerifyCode(int verifySize, String sources) {
        if (sources == null || sources.length() == 0) {
            sources = VERIFY_CODES;
        }
        int codeLen = sources.length();
        Random rand = new Random(System.currentTimeMillis());
        StringBuilder verifyCode = new StringBuilder(verifySize);
        for (int i = 0; i < verifySize; ++i) {
            verifyCode.append(sources.charAt(rand.nextInt(codeLen - 1)));
        }
        return verifyCode.toString();
    }
}

