/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.api.validate.code;

import java.lang.reflect.Field;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.Transient;
import org.springframework.web.context.request.ServletWebRequest;
import top.dcenter.ums.security.core.api.validate.code.ValidateCodeGenerator;
import top.dcenter.ums.security.core.api.validate.code.ValidateCodeProcessor;
import top.dcenter.ums.security.core.auth.validate.codes.ValidateCode;
import top.dcenter.ums.security.core.auth.validate.codes.ValidateCodeGeneratorHolder;
import top.dcenter.ums.security.core.auth.validate.codes.ValidateCodeType;
import top.dcenter.ums.security.core.enums.ErrorCodeEnum;
import top.dcenter.ums.security.core.exception.ValidateCodeException;
import top.dcenter.ums.security.core.util.MvcUtil;

public abstract class AbstractValidateCodeProcessor
implements ValidateCodeProcessor {
    private static final Logger log = LoggerFactory.getLogger(AbstractValidateCodeProcessor.class);
    protected ValidateCodeGeneratorHolder validateCodeGeneratorHolder;

    public AbstractValidateCodeProcessor(ValidateCodeGeneratorHolder validateCodeGeneratorHolder) {
        this.validateCodeGeneratorHolder = validateCodeGeneratorHolder;
    }

    @Override
    public final boolean produce(ServletWebRequest request) throws ValidateCodeException {
        HttpServletRequest req = request.getRequest();
        HttpSession session = req.getSession();
        String ip = req.getRemoteAddr();
        String sid = request.getSessionId();
        String uri = req.getRequestURI();
        try {
            ValidateCode validateCode = this.generate(request);
            boolean validateStatus = this.sent(request, validateCode);
            if (!validateStatus) {
                log.warn("\u53d1\u9001\u9a8c\u8bc1\u7801\u5931\u8d25: ip={}, sid={}, uri={}, validateCode={}", new Object[]{ip, sid, MvcUtil.getServletContextPath() + uri, validateCode.toString()});
                return false;
            }
            this.saveSession(request, validateCode);
        }
        catch (Exception e) {
            session.removeAttribute(this.getValidateCodeType().getSessionKey());
            if (e instanceof ValidateCodeException) {
                ValidateCodeException exception = (ValidateCodeException)((Object)e);
                String msg = String.format("\u751f\u6210\u9a8c\u8bc1\u7801\u5931\u8d25: error=%s, ip=%s, uid=%s, sid=%s, uri=%s, data=%s", exception.getMessage(), ip, exception.getUid(), sid, uri, exception.getData());
                log.warn(msg, (Throwable)((Object)exception));
                throw exception;
            }
            String msg = String.format("\u751f\u6210\u9a8c\u8bc1\u7801\u5931\u8d25: error=%s, ip=%s, sid=%s, uri=%s", e.getMessage(), ip, sid, uri);
            log.warn(msg, (Throwable)e);
            throw new ValidateCodeException(ErrorCodeEnum.GET_VALIDATE_CODE_FAILURE, (Throwable)e, ip, uri);
        }
        return true;
    }

    @Override
    public final ValidateCode generate(ServletWebRequest request) {
        try {
            ValidateCodeGenerator<?> validateCodeGenerator = this.getValidateCodeGenerator(this.getValidateCodeType());
            return (ValidateCode)validateCodeGenerator.generate((ServletRequest)request.getRequest());
        }
        catch (ValidateCodeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ValidateCodeException(ErrorCodeEnum.GET_VALIDATE_CODE_FAILURE, (Throwable)e, request.getRequest().getRemoteAddr(), request.getRequest().getRequestURI());
        }
    }

    @Override
    public boolean saveSession(ServletWebRequest request, ValidateCode validateCode) {
        HttpServletRequest req = request.getRequest();
        try {
            ValidateCodeType validateCodeType = this.getValidateCodeType();
            if (validateCodeType == null) {
                return false;
            }
            this.removeUnnecessaryFieldValue(validateCode);
            req.getSession().setAttribute(validateCodeType.getSessionKey(), (Object)validateCode);
        }
        catch (Exception e) {
            String msg = String.format("\u9a8c\u8bc1\u7801\u4fdd\u5b58\u5230Session\u5931\u8d25: error=%s, ip=%s, code=%s", e.getMessage(), req.getRemoteAddr(), validateCode);
            log.error(msg, (Throwable)e);
            return false;
        }
        return true;
    }

    private void removeUnnecessaryFieldValue(ValidateCode validateCode) throws IllegalAccessException {
        Field[] fields;
        for (Field field : fields = validateCode.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            Transient aTransient = field.getDeclaredAnnotation(Transient.class);
            if (aTransient == null) continue;
            field.set(validateCode, null);
        }
    }

    @Override
    public abstract boolean sent(ServletWebRequest var1, ValidateCode var2);

    @Override
    public void validate(ServletWebRequest request) throws ValidateCodeException {
        ValidateCodeType validateCodeType = this.getValidateCodeType();
        ValidateCodeGenerator<?> validateCodeGenerator = this.getValidateCodeGenerator(validateCodeType);
        validateCodeGenerator.validate(request);
    }

    @Override
    public abstract ValidateCodeType getValidateCodeType();

    private ValidateCodeGenerator<?> getValidateCodeGenerator(ValidateCodeType type) throws ValidateCodeException {
        try {
            ValidateCodeGenerator<?> validateCodeGenerator = this.validateCodeGeneratorHolder.findValidateCodeGenerator(type);
            if (validateCodeGenerator != null) {
                return validateCodeGenerator;
            }
            throw new ValidateCodeException(ErrorCodeEnum.ILLEGAL_VALIDATE_CODE_TYPE, null, type.name());
        }
        catch (Exception e) {
            throw new ValidateCodeException(ErrorCodeEnum.ILLEGAL_VALIDATE_CODE_TYPE, (Throwable)e, null, type.name());
        }
    }
}

