/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.controller;

import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import top.dcenter.ums.security.core.api.controller.BaseSecurityController;
import top.dcenter.ums.security.core.enums.ErrorCodeEnum;
import top.dcenter.ums.security.core.exception.IllegalAccessUrlException;
import top.dcenter.ums.security.core.properties.ClientProperties;
import top.dcenter.ums.security.core.util.MvcUtil;

@ResponseBody
public class ClientSecurityController
implements BaseSecurityController {
    private static final Logger log = LoggerFactory.getLogger(ClientSecurityController.class);
    public static final String URL_REGEX = "^.*://[^/]*(/.*$)";
    public static final String URI_$1 = "$1";
    private final RequestCache requestCache;
    private final RedirectStrategy redirectStrategy;
    private final ClientProperties clientProperties;
    private final AntPathMatcher pathMatcher;
    private final Map<String, String> authRedirectUrls;

    public ClientSecurityController(ClientProperties clientProperties) {
        this.clientProperties = clientProperties;
        this.requestCache = new HttpSessionRequestCache();
        this.redirectStrategy = new DefaultRedirectStrategy();
        this.authRedirectUrls = clientProperties.getAuthRedirectSuffixCondition().stream().map(pair -> pair.split("=")).collect(Collectors.toMap(arr -> arr[0], arr -> arr[1]));
        this.pathMatcher = new AntPathMatcher();
    }

    @Override
    @RequestMapping(value={"/authentication/require"})
    @ConditionalOnProperty(prefix="security.client", name={"login_un_authentication_url"}, havingValue="/authentication/require")
    public void requireAuthentication(HttpServletRequest request, HttpServletResponse response) {
        try {
            String targetUrl;
            SavedRequest savedRequest = this.requestCache.getRequest(request, response);
            if (savedRequest != null && StringUtils.isNotBlank((String)(targetUrl = savedRequest.getRedirectUrl()))) {
                targetUrl = targetUrl.replaceFirst(URL_REGEX, URI_$1);
                String contextPath = request.getServletContext().getContextPath();
                targetUrl = StringUtils.substringAfter((String)targetUrl, (String)contextPath);
                for (Map.Entry<String, String> entry : this.authRedirectUrls.entrySet()) {
                    if (!this.pathMatcher.match(entry.getKey(), targetUrl)) continue;
                    this.redirectStrategy.sendRedirect(request, response, entry.getValue());
                    return;
                }
            }
            this.redirectStrategy.sendRedirect(request, response, this.clientProperties.getLoginPage());
        }
        catch (Exception e) {
            String requestUri = request.getRequestURI();
            String ip = request.getRemoteAddr();
            String msg = String.format("IllegalAccessUrlException: ip=%s, uri=%s, sid=%s, error=%s", ip, MvcUtil.getServletContextPath() + requestUri, request.getSession(true).getId(), e.getMessage());
            log.error(msg, (Throwable)e);
            throw new IllegalAccessUrlException(ErrorCodeEnum.SERVER_ERROR, requestUri, ip);
        }
    }
}

