/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.handler;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.util.StringUtils;
import top.dcenter.ums.security.core.api.authentication.handler.BaseAuthenticationSuccessHandler;
import top.dcenter.ums.security.core.enums.LoginProcessType;
import top.dcenter.ums.security.core.properties.ClientProperties;
import top.dcenter.ums.security.core.util.AuthenticationUtil;
import top.dcenter.ums.security.core.util.MvcUtil;
import top.dcenter.ums.security.core.vo.ResponseResult;
import top.dcenter.ums.security.core.vo.UserInfoJsonVo;

public class ClientAuthenticationSuccessHandler
extends BaseAuthenticationSuccessHandler {
    private static final Logger log = LoggerFactory.getLogger(ClientAuthenticationSuccessHandler.class);
    protected final ClientProperties clientProperties;
    protected final ObjectMapper objectMapper;
    protected final RequestCache requestCache;

    public ClientAuthenticationSuccessHandler(ObjectMapper objectMapper, ClientProperties clientProperties) {
        this.objectMapper = objectMapper;
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.requestCache = new HttpSessionRequestCache();
        this.clientProperties = clientProperties;
        this.setTargetUrlParameter(clientProperties.getTargetUrlParameter());
        this.setUseReferer(clientProperties.getUseReferer());
        this.loginUrls = new HashSet();
        this.loginUrls.add(clientProperties.getLoginPage());
        this.loginUrls.add(clientProperties.getLogoutUrl());
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        String username = authentication.getName();
        String ip = request.getRemoteAddr();
        String userAgent = request.getHeader("User-Agent");
        String sid = request.getSession(true).getId();
        log.info("\u767b\u5f55\u6210\u529f: user={}, ip={}, ua={}, sid={}", new Object[]{username, ip, userAgent, sid});
        AbstractAuthenticationToken token = (AbstractAuthenticationToken)authentication;
        try {
            UserInfoJsonVo userInfoJsonVo = new UserInfoJsonVo(null, username, null, token.getAuthorities());
            SavedRequest savedRequest = this.requestCache.getRequest(request, response);
            Object targetUrl = MvcUtil.getServletContextPath() + this.getDefaultTargetUrl();
            if (savedRequest != null) {
                targetUrl = (String)((Object)Objects.requireNonNullElse(savedRequest.getRedirectUrl(), targetUrl));
            }
            userInfoJsonVo.setUrl((String)targetUrl);
            if (LoginProcessType.JSON.equals((Object)this.clientProperties.getLoginProcessType())) {
                AuthenticationUtil.responseWithJson(response, HttpStatus.OK.value(), this.objectMapper.writeValueAsString((Object)ResponseResult.success(userInfoJsonVo)));
                return;
            }
            String acceptHeader = request.getHeader("accept");
            if (org.apache.commons.lang.StringUtils.isNotBlank((String)acceptHeader) && acceptHeader.contains("application/json")) {
                AuthenticationUtil.responseWithJson(response, HttpStatus.OK.value(), this.objectMapper.writeValueAsString((Object)ResponseResult.success(userInfoJsonVo)));
                return;
            }
        }
        catch (Exception e) {
            log.error(String.format("\u8bbe\u7f6e\u767b\u5f55\u6210\u529f\u540e\u8df3\u8f6c\u7684URL\u5931\u8d25: error=%s, user=%s, ip=%s, ua=%s, sid=%s", e.getMessage(), username, ip, userAgent, sid), (Throwable)e);
        }
        super.onAuthenticationSuccess(request, response, authentication);
    }

    protected String determineTargetUrl(HttpServletRequest request, HttpServletResponse response) {
        String defaultTargetUrl = this.getDefaultTargetUrl();
        if (this.isAlwaysUseDefaultTargetUrl()) {
            return defaultTargetUrl;
        }
        String targetUrl = null;
        String targetUrlParameter = this.getTargetUrlParameter();
        if (targetUrlParameter != null && StringUtils.hasText((String)(targetUrl = request.getParameter(targetUrlParameter)))) {
            return targetUrl;
        }
        if (this.useReferer && !StringUtils.hasLength((String)targetUrl) && org.apache.commons.lang.StringUtils.isNotBlank((String)(targetUrl = request.getHeader("Referer"))) && this.isLoginUrl(targetUrl)) {
            targetUrl = defaultTargetUrl;
        }
        if (!StringUtils.hasText((String)targetUrl)) {
            targetUrl = defaultTargetUrl;
        }
        return targetUrl;
    }

    public void setUseReferer(boolean useReferer) {
        super.setUseReferer(useReferer);
        this.useReferer = useReferer;
    }

    private boolean isLoginUrl(String targetUrl) {
        return this.loginUrls.stream().anyMatch(targetUrl::contains);
    }
}

