/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.api.session.strategy;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.session.InvalidSessionStrategy;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import top.dcenter.ums.security.core.util.AuthenticationUtil;
import top.dcenter.ums.security.core.util.MvcUtil;

public final class DefaultRedirectInvalidSessionStrategy
implements InvalidSessionStrategy {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final String destinationUrl;
    private final RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
    private boolean createNewSession = true;
    private final AntPathMatcher matcher;

    public DefaultRedirectInvalidSessionStrategy(String invalidSessionUrl) {
        Assert.isTrue((boolean)UrlUtils.isValidRedirectUrl((String)invalidSessionUrl), (String)"url must start with '/' or with 'http(s)'");
        this.destinationUrl = invalidSessionUrl;
        this.matcher = new AntPathMatcher();
    }

    public void onInvalidSessionDetected(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession();
        String redirectUrl = this.destinationUrl;
        String requestUri = MvcUtil.getUrlPathHelper().getPathWithinApplication(request);
        if (AuthenticationUtil.isPermitUri(requestUri, session, this.matcher)) {
            redirectUrl = requestUri;
        }
        this.logger.debug((Object)("Starting new session (if required) and redirecting to '" + redirectUrl + "'"));
        if (this.createNewSession) {
            request.getSession();
        }
        request.getSession().removeAttribute("SESSION_ENHANCE_CHECK_KEY");
        this.redirectStrategy.sendRedirect(request, response, redirectUrl);
    }

    public void setCreateNewSession(boolean createNewSession) {
        this.createNewSession = createNewSession;
    }
}

