/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.filter;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.FilterChain;
import javax.servlet.ReadListener;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;
import top.dcenter.ums.security.core.util.ConvertUtil;

public class AjaxOrFormRequestFilter
extends OncePerRequestFilter {
    public static final String VALIDATE_JSON_PREFIX = "{";
    private ObjectMapper objectMapper;

    public AjaxOrFormRequestFilter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    protected void doFilterInternal(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        filterChain.doFilter((ServletRequest)new AjaxOrFormRequest(request, this.objectMapper), (ServletResponse)response);
    }

    private static class BodyInputStream
    extends ServletInputStream {
        private final InputStream delegate;

        public BodyInputStream(byte[] body) {
            this.delegate = new ByteArrayInputStream(body);
        }

        public boolean isFinished() {
            return false;
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener readListener) {
            throw new UnsupportedOperationException();
        }

        public int read() throws IOException {
            return this.delegate.read();
        }

        public int read(@NotNull byte[] b, int off, int len) throws IOException {
            return this.delegate.read(b, off, len);
        }

        public int read(@NotNull byte[] b) throws IOException {
            return this.delegate.read(b);
        }

        public long skip(long n) throws IOException {
            return this.delegate.skip(n);
        }

        public int available() throws IOException {
            return this.delegate.available();
        }

        public void close() throws IOException {
            this.delegate.close();
        }

        public synchronized void mark(int readlimit) {
            this.delegate.mark(readlimit);
        }

        public synchronized void reset() throws IOException {
            this.delegate.reset();
        }

        public boolean markSupported() {
            return this.delegate.markSupported();
        }
    }

    public static class AjaxOrFormRequest
    extends HttpServletRequestWrapper {
        private static final Logger log = LoggerFactory.getLogger(AjaxOrFormRequest.class);
        private ObjectMapper objectMapper;
        private final byte[] body;
        private final Map<String, Object> formMap;

        AjaxOrFormRequest(HttpServletRequest request, ObjectMapper objectMapper) {
            super(request);
            boolean isJsonOrFormContentType;
            this.objectMapper = objectMapper;
            String contentType = request.getContentType();
            String method = request.getMethod();
            boolean isPostOrPutRequest = "POST".equalsIgnoreCase(method) || "PUT".equalsIgnoreCase(method);
            boolean bl = isJsonOrFormContentType = contentType != null && (contentType.contains("application/x-www-form-urlencoded") || contentType.contains("application/json"));
            if (isPostOrPutRequest && isJsonOrFormContentType) {
                Map map = null;
                byte[] bytes = null;
                try {
                    bytes = request.getInputStream().readAllBytes();
                    if (bytes.length != 0) {
                        String jsonData = new String(bytes, StandardCharsets.UTF_8).trim();
                        map = StringUtils.startsWith((CharSequence)jsonData, (CharSequence)AjaxOrFormRequestFilter.VALIDATE_JSON_PREFIX) ? (Map)this.objectMapper.readValue(jsonData, Map.class) : ConvertUtil.string2JsonMap(jsonData, "&", "=");
                    }
                }
                catch (Exception e) {
                    log.error(String.format("\u8bfb\u53d6\u8bf7\u6c42\u6570\u636e\u5931\u8d25: %s", e.getMessage()), (Throwable)e);
                }
                this.formMap = Objects.requireNonNullElse(map, new HashMap(0));
                this.body = bytes;
            } else {
                this.body = null;
                this.formMap = null;
            }
        }

        public ServletInputStream getInputStream() throws IOException {
            if (this.body == null) {
                return super.getInputStream();
            }
            return new BodyInputStream(this.body);
        }

        public String getParameter(String name) {
            if (this.formMap == null) {
                return super.getParameter(name);
            }
            return (String)this.formMap.get(name);
        }

        public byte[] getBody() {
            return this.body;
        }

        public Map<String, Object> getFormMap() {
            return this.formMap;
        }
    }
}

