/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.web.context.WebApplicationContext;
import top.dcenter.ums.security.core.api.authentication.handler.BaseAuthenticationFailureHandler;
import top.dcenter.ums.security.core.api.authentication.handler.BaseAuthenticationSuccessHandler;
import top.dcenter.ums.security.core.api.config.HttpSecurityAware;
import top.dcenter.ums.security.core.api.logout.DefaultLogoutSuccessHandler;
import top.dcenter.ums.security.core.api.service.AbstractUserDetailsService;
import top.dcenter.ums.security.core.auth.filter.AjaxOrFormRequestFilter;
import top.dcenter.ums.security.core.auth.provider.UsernamePasswordAuthenticationProvider;
import top.dcenter.ums.security.core.config.ClientAutoConfigurerAware;
import top.dcenter.ums.security.core.config.CsrfAutoConfigurerAware;
import top.dcenter.ums.security.core.config.RememberMeAutoConfigurerAware;
import top.dcenter.ums.security.core.config.SecurityAutoConfiguration;
import top.dcenter.ums.security.core.config.SessionAutoConfigurerAware;
import top.dcenter.ums.security.core.config.SmsCodeLoginAuthenticationAutoConfigurerAware;
import top.dcenter.ums.security.core.config.ValidateCodeAutoConfigurerAware;
import top.dcenter.ums.security.core.properties.ClientProperties;

@Configuration
@EnableWebSecurity
@AutoConfigureAfter(value={SecurityAutoConfiguration.class, SmsCodeLoginAuthenticationAutoConfigurerAware.class, ClientAutoConfigurerAware.class, CsrfAutoConfigurerAware.class, RememberMeAutoConfigurerAware.class, SessionAutoConfigurerAware.class, ValidateCodeAutoConfigurerAware.class})
public class SecurityCoreAutoConfigurer
extends WebSecurityConfigurerAdapter {
    private static final Logger log = LoggerFactory.getLogger(SecurityCoreAutoConfigurer.class);
    private final ClientProperties clientProperties;
    private final BaseAuthenticationSuccessHandler baseAuthenticationSuccessHandler;
    private final BaseAuthenticationFailureHandler baseAuthenticationFailureHandler;
    private final ObjectMapper objectMapper;
    private final UsernamePasswordAuthenticationProvider usernamePasswordAuthenticationProvider;
    private final DefaultLogoutSuccessHandler defaultLogoutSuccessHandler;
    private final PasswordEncoder passwordEncoder;
    @Autowired(required=false)
    private Map<String, HttpSecurityAware> socialWebSecurityConfigurerMap;
    @Autowired(required=false)
    private AbstractUserDetailsService abstractUserDetailsService;

    public SecurityCoreAutoConfigurer(ClientProperties clientProperties, BaseAuthenticationSuccessHandler baseAuthenticationSuccessHandler, BaseAuthenticationFailureHandler baseAuthenticationFailureHandler, ObjectMapper objectMapper, UsernamePasswordAuthenticationProvider usernamePasswordAuthenticationProvider, DefaultLogoutSuccessHandler defaultLogoutSuccessHandler, PasswordEncoder passwordEncoder) {
        this.clientProperties = clientProperties;
        this.baseAuthenticationSuccessHandler = baseAuthenticationSuccessHandler;
        this.baseAuthenticationFailureHandler = baseAuthenticationFailureHandler;
        this.objectMapper = objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.usernamePasswordAuthenticationProvider = usernamePasswordAuthenticationProvider;
        this.defaultLogoutSuccessHandler = defaultLogoutSuccessHandler;
        this.passwordEncoder = passwordEncoder;
    }

    public void configure(WebSecurity web) {
        String[] ignoringUrls = this.clientProperties.getIgnoringUrls();
        web.ignoring().antMatchers(Objects.requireNonNullElseGet(ignoringUrls, () -> new String[0]));
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        if (this.abstractUserDetailsService == null) {
            throw new RuntimeException("\u5fc5\u987b\u5b9e\u73b0 AbstractUserDetailsService \u6216 top.dcenter.security.social.api.service.AbstractSocialUserDetailsService \u62bd\u8c61\u7c7b");
        }
        auth.userDetailsService((UserDetailsService)this.abstractUserDetailsService).passwordEncoder(this.passwordEncoder);
    }

    protected void configure(HttpSecurity http) throws Exception {
        HashMap<String, Set<String>> authorizeRequestMap = new HashMap<String, Set<String>>(16);
        HashMap<String, Map<String, Set<String>>> authorizeRequestMapPlus = new HashMap<String, Map<String, Set<String>>>(16);
        this.groupingAuthorizeRequestUris(http, authorizeRequestMap, authorizeRequestMapPlus);
        String[] permitAllArray = this.set2ArrayByType(authorizeRequestMap, "permitAll");
        String[] denyAllArray = this.set2ArrayByType(authorizeRequestMap, "denyAll");
        String[] anonymousArray = this.set2ArrayByType(authorizeRequestMap, "anonymous");
        String[] authenticatedArray = this.set2ArrayByType(authorizeRequestMap, "authenticated");
        String[] fullyAuthenticatedArray = this.set2ArrayByType(authorizeRequestMap, "fullyAuthenticated");
        String[] rememberMeArray = this.set2ArrayByType(authorizeRequestMap, "rememberMe");
        Map<String, String[]> hasRoleMap = this.toMapPlusByType(authorizeRequestMapPlus, "hasRole");
        Map<String, String[]> hasAnyRoleMap = this.toMapPlusByType(authorizeRequestMapPlus, "hasAnyRole");
        Map<String, String[]> hasAuthorityMap = this.toMapPlusByType(authorizeRequestMapPlus, "hasAuthority");
        Map<String, String[]> hasAnyAuthorityMap = this.toMapPlusByType(authorizeRequestMapPlus, "hasAnyAuthority");
        Map<String, String[]> hasIpAddressMap = this.toMapPlusByType(authorizeRequestMapPlus, "hasIpAddress");
        http.addFilterBefore((Filter)new AjaxOrFormRequestFilter(this.objectMapper), CsrfFilter.class);
        String loginUnAuthenticationRoutingUrl = this.clientProperties.getLoginUnAuthenticationRoutingUrl();
        if (!this.clientProperties.getOpenAuthenticationRedirect().booleanValue()) {
            loginUnAuthenticationRoutingUrl = this.clientProperties.getLogoutUrl();
        }
        ((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)http.authenticationProvider((AuthenticationProvider)this.usernamePasswordAuthenticationProvider).formLogin().usernameParameter(this.clientProperties.usernameParameter).passwordParameter(this.clientProperties.passwordParameter).loginPage(loginUnAuthenticationRoutingUrl).failureUrl(this.clientProperties.getFailureUrl())).defaultSuccessUrl(this.clientProperties.getSuccessUrl())).loginProcessingUrl(this.clientProperties.getLoginProcessingUrl())).successHandler((AuthenticationSuccessHandler)this.baseAuthenticationSuccessHandler)).failureHandler((AuthenticationFailureHandler)this.baseAuthenticationFailureHandler);
        this.anonymousConfigurer(http);
        this.urlAuthorizationConfigurer(http, permitAllArray, denyAllArray, anonymousArray, authenticatedArray, fullyAuthenticatedArray, rememberMeArray, hasRoleMap, hasAnyRoleMap, hasAuthorityMap, hasAnyAuthorityMap, hasIpAddressMap);
        this.logoutConfigurer(http);
        if (this.clientProperties.getSameOrigin().booleanValue()) {
            http.headers().frameOptions().sameOrigin();
        }
        if (this.socialWebSecurityConfigurerMap != null) {
            for (HttpSecurityAware postConfigurer : this.socialWebSecurityConfigurerMap.values()) {
                postConfigurer.postConfigure(http);
            }
        }
    }

    private void anonymousConfigurer(HttpSecurity http) throws Exception {
        ClientProperties.AnonymousProperties anonymous = this.clientProperties.getAnonymous();
        String[] authorities = new String[anonymous.getAuthorities().size()];
        anonymous.getAuthorities().toArray(authorities);
        if (anonymous.getAnonymousIsOpen().booleanValue()) {
            http.anonymous().principal((Object)anonymous.getPrincipal()).authorities(authorities);
        } else {
            http.anonymous().disable();
        }
    }

    private void logoutConfigurer(HttpSecurity http) throws Exception {
        http.logout().logoutUrl(this.clientProperties.getLogoutUrl()).logoutSuccessHandler((LogoutSuccessHandler)this.defaultLogoutSuccessHandler).logoutSuccessUrl(this.clientProperties.getLogoutSuccessUrl()).deleteCookies(new String[]{this.clientProperties.getRememberMe().getRememberMeCookieName(), this.clientProperties.getSession().getSessionCookieName()}).clearAuthentication(true).invalidateHttpSession(true);
    }

    private void urlAuthorizationConfigurer(HttpSecurity http, String[] permitAllArray, String[] denyAllArray, String[] anonymousArray, String[] authenticatedArray, String[] fullyAuthenticatedArray, String[] rememberMeArray, Map<String, String[]> hasRoleMap, Map<String, String[]> hasAnyRoleMap, Map<String, String[]> hasAuthorityMap, Map<String, String[]> hasAnyAuthorityMap, Map<String, String[]> hasIpAddressMap) throws Exception {
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry expressionInterceptUrlRegistry = http.authorizeRequests();
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)expressionInterceptUrlRegistry.antMatchers(permitAllArray)).permitAll().antMatchers(denyAllArray)).denyAll().antMatchers(anonymousArray)).anonymous().antMatchers(authenticatedArray)).authenticated().antMatchers(fullyAuthenticatedArray)).fullyAuthenticated().antMatchers(rememberMeArray)).rememberMe();
        hasRoleMap.forEach((uri, roleArr) -> ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)expressionInterceptUrlRegistry.antMatchers(new String[]{uri})).hasRole(roleArr[0]));
        hasAnyRoleMap.forEach((uri, roleArr) -> ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)expressionInterceptUrlRegistry.antMatchers(new String[]{uri})).hasAnyRole(roleArr));
        hasAuthorityMap.forEach((uri, authorityArr) -> {
            for (String s : authorityArr) {
                ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)expressionInterceptUrlRegistry.antMatchers(new String[]{uri})).hasAuthority(s);
            }
        });
        hasAnyAuthorityMap.forEach((uri, authorityArr) -> ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)expressionInterceptUrlRegistry.antMatchers(new String[]{uri})).hasAnyAuthority(authorityArr));
        hasIpAddressMap.forEach((uri, ipArr) -> {
            for (String s : ipArr) {
                ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)expressionInterceptUrlRegistry.antMatchers(new String[]{uri})).hasIpAddress(s);
            }
        });
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)expressionInterceptUrlRegistry.anyRequest()).authenticated();
    }

    @Bean
    public AuthenticationManager authenticationManagerBean() throws Exception {
        return super.authenticationManagerBean();
    }

    private String[] set2ArrayByType(Map<String, Set<String>> authorizeRequestMap, String authorizeRequestType) {
        Set<String> set = authorizeRequestMap.get(authorizeRequestType);
        if (set != null) {
            Object[] uriArray = new String[set.size()];
            set.toArray(uriArray);
            if (log.isDebugEnabled()) {
                log.debug("{} = {}", (Object)authorizeRequestType, (Object)Arrays.toString(uriArray));
            }
            return uriArray;
        }
        return new String[0];
    }

    private Map<String, String[]> toMapPlusByType(Map<String, Map<String, Set<String>>> authorizeRequestMap, String authorizeRequestType) {
        Map<String, Set<String>> map = authorizeRequestMap.get(authorizeRequestType);
        if (map != null) {
            return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
                Set value = (Set)entry.getValue();
                int length = value.size();
                String[] authorityArr = new String[length];
                return value.toArray(authorityArr);
            }));
        }
        return new HashMap<String, String[]>(0);
    }

    private void groupingAuthorizeRequestUris(@NonNull HttpSecurity http, @NonNull Map<String, Set<String>> targetAuthorizeRequestMap, @NonNull Map<String, Map<String, Set<String>>> targetAuthorizeRequestMapPlus) throws Exception {
        if (this.socialWebSecurityConfigurerMap != null) {
            for (HttpSecurityAware configurer : this.socialWebSecurityConfigurerMap.values()) {
                configurer.preConfigure(http);
                Map<String, Map<String, Set<String>>> authorizeRequestMap = configurer.getAuthorizeRequestMap();
                this.groupByMap(targetAuthorizeRequestMap, authorizeRequestMap, "permitAll");
                this.groupByMap(targetAuthorizeRequestMap, authorizeRequestMap, "denyAll");
                this.groupByMap(targetAuthorizeRequestMap, authorizeRequestMap, "anonymous");
                this.groupByMap(targetAuthorizeRequestMap, authorizeRequestMap, "authenticated");
                this.groupByMap(targetAuthorizeRequestMap, authorizeRequestMap, "fullyAuthenticated");
                this.groupByMap(targetAuthorizeRequestMap, authorizeRequestMap, "rememberMe");
                this.groupByMapPlus(targetAuthorizeRequestMapPlus, authorizeRequestMap, "hasRole");
                this.groupByMapPlus(targetAuthorizeRequestMapPlus, authorizeRequestMap, "hasAnyRole");
                this.groupByMapPlus(targetAuthorizeRequestMapPlus, authorizeRequestMap, "hasAuthority");
                this.groupByMapPlus(targetAuthorizeRequestMapPlus, authorizeRequestMap, "hasAnyAuthority");
                this.groupByMapPlus(targetAuthorizeRequestMapPlus, authorizeRequestMap, "hasIpAddress");
            }
            ApplicationContext applicationContext = this.getApplicationContext();
            WebApplicationContext servletContext = (WebApplicationContext)applicationContext;
            Objects.requireNonNull(servletContext.getServletContext()).setAttribute("SERVLET_CONTEXT_AUTHORIZE_REQUESTS_MAP_KEY", targetAuthorizeRequestMap);
        }
    }

    private void groupByMap(@NonNull Map<String, Set<String>> targetAuthorizeRequestMap, @Nullable Map<String, Map<String, Set<String>>> srcAuthorizeRequestMap, @NonNull String authorizeRequestType) {
        if (srcAuthorizeRequestMap != null) {
            Map<String, Set<String>> stringSetMap = srcAuthorizeRequestMap.get(authorizeRequestType);
            if (stringSetMap == null) {
                return;
            }
            Set<String> uriSet = stringSetMap.keySet();
            targetAuthorizeRequestMap.compute(authorizeRequestType, (k, v) -> {
                if (v == null) {
                    v = new HashSet(uriSet.size());
                }
                v.addAll(uriSet);
                return v;
            });
        }
    }

    private void groupByMapPlus(@NonNull Map<String, Map<String, Set<String>>> targetAuthorizeRequestMap, @Nullable Map<String, Map<String, Set<String>>> srcAuthorizeRequestMap, @NonNull String authorizeRequestType) {
        if (srcAuthorizeRequestMap != null) {
            Map<String, Set<String>> map = srcAuthorizeRequestMap.get(authorizeRequestType);
            if (map == null) {
                map = new HashMap<String, Set<String>>(0);
            }
            Map<String, Set<String>> uriAuthorizeMap = map;
            targetAuthorizeRequestMap.compute(authorizeRequestType, (k, v) -> {
                if (v == null) {
                    v = new HashMap(uriAuthorizeMap.size());
                }
                v.putAll(uriAuthorizeMap);
                return v;
            });
        }
    }
}

