/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.util;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import top.dcenter.ums.security.core.util.MvcUtil;

public class ConvertUtil {
    public static Set<String> string2Set(String str, String separator) {
        String[] splits = StringUtils.splitByWholeSeparator((String)str, (String)separator);
        if (splits == null) {
            return new HashSet<String>();
        }
        return Stream.of(splits).collect(Collectors.toSet());
    }

    public static List<String> string2List(String str, String separator) {
        String[] splits = StringUtils.splitByWholeSeparator((String)str, (String)separator);
        if (splits == null) {
            return new ArrayList<String>();
        }
        return Stream.of(splits).collect(Collectors.toList());
    }

    public static <T> Map<String, T> list2Map(List<String> list, T value) {
        return list.stream().collect(Collectors.toMap(Function.identity(), s -> value));
    }

    public static <T> void list2Map(List<String> list, T value, Map<String, T> map) {
        list.forEach(s -> map.put((String)s, value));
    }

    public static <T> void list2MapWithServletContextPath(List<String> list, T value, Map<String, T> map) {
        list.forEach(s -> map.put(MvcUtil.getServletContextPath() + s, value));
    }

    public static Map<String, Object> string2JsonMap(String kvStrings, String separator, String kvSeparator) {
        String[] splits = StringUtils.splitByWholeSeparator((String)kvStrings, (String)separator);
        if (splits == null) {
            return new JsonMap<String, Object>(0);
        }
        int length = splits.length;
        JsonMap<String, Object> map = new JsonMap<String, Object>(length);
        ConvertUtil.string2JsonMap(kvSeparator, splits, map);
        return map;
    }

    private static void string2JsonMap(String kvSeparator, String[] splits, Map<String, Object> map) {
        for (String split : splits) {
            String[] kvArr;
            if (!StringUtils.isNotBlank((CharSequence)split) || (kvArr = StringUtils.splitByWholeSeparator((String)split, (String)kvSeparator)) == null || kvArr.length != 2) continue;
            map.compute(kvArr[0], (k, v) -> {
                if (v == null) {
                    v = URLDecoder.decode(kvArr[1], StandardCharsets.UTF_8);
                } else if (v instanceof JsonList) {
                    ((JsonList)v).add(URLDecoder.decode(kvArr[1], StandardCharsets.UTF_8));
                } else {
                    JsonList<Object> list = new JsonList<Object>();
                    list.add(v);
                    list.add(URLDecoder.decode(kvArr[1], StandardCharsets.UTF_8));
                    v = list;
                }
                return v;
            });
        }
    }

    public static <T> Map<String, T> keyString2Map(String keyStr, String separator, T value) {
        String[] splits = StringUtils.splitByWholeSeparator((String)keyStr, (String)separator);
        if (splits == null) {
            return new HashMap(0);
        }
        int length = splits.length;
        HashMap<String, T> map = new HashMap<String, T>(length);
        for (String split : splits) {
            map.put(split, value);
        }
        return map;
    }

    public static <T> void keyString2Map(String keyStr, String separator, T value, Map<String, T> map) {
        String[] splits = StringUtils.splitByWholeSeparator((String)keyStr, (String)separator);
        if (splits == null) {
            return;
        }
        for (String split : splits) {
            map.put(split, value);
        }
    }

    private static class JsonList<E>
    extends ArrayList<E> {
        private static final long serialVersionUID = 752591930857178273L;

        public JsonList(int initialCapacity) {
            super(initialCapacity);
        }

        public JsonList() {
        }

        public JsonList(@NotNull Collection<? extends E> c) {
            super(c);
        }

        @Override
        public String toString() {
            Iterator it = this.iterator();
            if (!it.hasNext()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            while (true) {
                Object e;
                if ((e = it.next()) == this) {
                    continue;
                }
                sb.append("\"");
                sb.append(e);
                sb.append("\"");
                if (!it.hasNext()) {
                    return sb.append(']').toString();
                }
                sb.append(',');
            }
        }
    }

    private static class JsonMap<K, V>
    extends HashMap<K, V> {
        private static final long serialVersionUID = 5603812891003320178L;

        public JsonMap(int initialCapacity, float loadFactor) {
            super(initialCapacity, loadFactor);
        }

        public JsonMap(int initialCapacity) {
            super(initialCapacity);
        }

        public JsonMap() {
        }

        public JsonMap(Map<? extends K, ? extends V> m) {
            super(m);
        }

        @Override
        public String toString() {
            Iterator i = this.entrySet().iterator();
            if (!i.hasNext()) {
                return "{}";
            }
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            while (true) {
                Map.Entry e = i.next();
                Object key = e.getKey();
                Object value = e.getValue();
                if (key == this) continue;
                sb.append("\"");
                sb.append(key);
                sb.append("\"");
                sb.append(":");
                if (value != this) {
                    if (value instanceof String) {
                        sb.append("\"");
                    }
                    sb.append(value);
                    if (value instanceof String) {
                        sb.append("\"");
                    }
                }
                if (!i.hasNext()) {
                    return sb.append('}').toString();
                }
                sb.append(',');
            }
        }
    }
}

