/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.validate.codes.image;

import java.awt.image.RenderedImage;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.ServletWebRequest;
import top.dcenter.ums.security.core.api.validate.code.AbstractValidateCodeProcessor;
import top.dcenter.ums.security.core.auth.validate.codes.ValidateCode;
import top.dcenter.ums.security.core.auth.validate.codes.ValidateCodeGeneratorHolder;
import top.dcenter.ums.security.core.auth.validate.codes.ValidateCodeType;
import top.dcenter.ums.security.core.auth.validate.codes.image.ImageCode;
import top.dcenter.ums.security.core.util.MvcUtil;

public class ImageValidateCodeProcessor
extends AbstractValidateCodeProcessor {
    private static final Logger log = LoggerFactory.getLogger(ImageValidateCodeProcessor.class);

    public ImageValidateCodeProcessor(ValidateCodeGeneratorHolder validateCodeGeneratorHolder) {
        super(validateCodeGeneratorHolder);
    }

    @Override
    public boolean sent(ServletWebRequest request, ValidateCode validateCode) {
        try {
            if (!(validateCode instanceof ImageCode)) {
                return false;
            }
            ImageCode imageCode = (ImageCode)validateCode;
            HttpServletResponse response = request.getResponse();
            if (response == null) {
                return false;
            }
            ImageIO.write((RenderedImage)imageCode.getImage(), "JPEG", (OutputStream)response.getOutputStream());
            return true;
        }
        catch (Exception e) {
            HttpServletRequest req = request.getRequest();
            log.error(String.format("\u53d1\u9001\u9a8c\u8bc1\u7801\u5931\u8d25: error=%s, ip=%s, sid=%s, uri=%s, validateCode=%s", e.getMessage(), req.getRemoteAddr(), request.getSessionId(), MvcUtil.getServletContextPath() + req.getRequestURI(), validateCode.toString()), (Throwable)e);
            return false;
        }
    }

    @Override
    public ValidateCodeType getValidateCodeType() {
        return ValidateCodeType.IMAGE;
    }
}

