/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.permission.filter;

import java.io.IOException;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.OncePerRequestFilter;
import top.dcenter.ums.security.core.api.permission.service.UriAuthorizeService;
import top.dcenter.ums.security.core.util.MvcUtil;

public class UriAuthorizeFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(UriAuthorizeFilter.class);
    private final UriAuthorizeService uriAuthorizeService;

    public UriAuthorizeFilter(UriAuthorizeService uriAuthorizeService) {
        this.uriAuthorizeService = uriAuthorizeService;
    }

    protected void doFilterInternal(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull FilterChain filterChain) throws ServletException, IOException {
        String requestUri = MvcUtil.getUrlPathHelper().getPathWithinApplication(request);
        Set<String> uriOfPermissionSet = ((Map)this.uriAuthorizeService.getUriAuthoritiesOfAllRole().orElse(new HashMap(0))).keySet();
        if (this.uriAuthorizeService.isUriContainsInUriSet(uriOfPermissionSet, requestUri).booleanValue()) {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            Map uriAuthorityOfUserRoleMap = this.uriAuthorizeService.getUriAuthoritiesOfUserRole(authentication).orElse(new HashMap(0));
            Object principal = authentication.getPrincipal();
            String sid = request.getSession(true).getId();
            String ip = request.getRemoteAddr();
            String uri = request.getRequestURI();
            long now = Instant.now().toEpochMilli();
            String referer = request.getHeader("referer");
            String userAgent = request.getHeader("User-Agent");
            String method = request.getMethod();
            if (this.uriAuthorizeService.isUriContainsInUriSet(uriAuthorityOfUserRoleMap.keySet(), requestUri).booleanValue()) {
                log.info("URI\u6743\u9650\u63a7\u5236-\u653e\u884c: sid={}, user={}, ip={}, uri={}, method={}, time={}, referer={}, agent={}", new Object[]{sid, principal, ip, uri, method, now, referer, userAgent});
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            log.warn("URI\u6743\u9650\u63a7\u5236-\u7981\u6b62: sid={}, user={}, ip={}, uri={}, method={}, time={}, referer={}, agent={}", new Object[]{sid, principal, ip, uri, method, now, referer, userAgent});
            this.uriAuthorizeService.handlerError(HttpStatus.FORBIDDEN.value(), response);
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

