/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.sign;

import java.io.UnsupportedEncodingException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.BitFieldSubCommands;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisPipelineException;
import org.springframework.lang.NonNull;
import top.dcenter.ums.security.core.api.sign.service.SignService;
import top.dcenter.ums.security.core.properties.SignProperties;
import top.dcenter.ums.security.core.util.SignUtil;

public class UserSignServiceImpl
implements SignService {
    private static final Logger log = LoggerFactory.getLogger(UserSignServiceImpl.class);
    private static final String PATTERN = "yyyy-MM-dd";
    private final RedisConnectionFactory redisConnectionFactory;
    private final SignProperties signProperties;
    private final String charset;

    public UserSignServiceImpl(RedisConnectionFactory redisConnectionFactory, SignProperties signProperties) {
        this.redisConnectionFactory = redisConnectionFactory;
        this.signProperties = signProperties;
        this.charset = signProperties.getCharset();
    }

    public RedisConnection getConnection() {
        return this.redisConnectionFactory.getConnection();
    }

    private byte[] buildSignKey(String uid, LocalDate date) throws UnsupportedEncodingException {
        return (this.signProperties.getSignKeyPrefix() + SignUtil.buildSignKey(uid, date)).getBytes(this.charset);
    }

    private byte[] buildTotalSignKey(LocalDate date) throws UnsupportedEncodingException {
        return (this.signProperties.getTotalSignKeyPrefix() + SignUtil.formatDate(date)).getBytes(this.charset);
    }

    private byte[] buildDayKey(LocalDate date) throws UnsupportedEncodingException {
        return Integer.toString(date.getDayOfMonth()).getBytes(this.charset);
    }

    @Override
    public long delSignByUidAndDate(@NonNull String uid, @NonNull LocalDate date) throws UnsupportedEncodingException {
        byte[] key = this.buildSignKey(uid, date);
        return this.del(key);
    }

    @Override
    public long delSignByUidAndDate(@NonNull Map<String, LocalDate> keyMap) throws UnsupportedEncodingException {
        ArrayList<byte[]> keyList = new ArrayList<byte[]>();
        Set<Map.Entry<String, LocalDate>> entries = keyMap.entrySet();
        for (Map.Entry<String, LocalDate> entry : entries) {
            keyList.add(this.buildSignKey(entry.getKey(), entry.getValue()));
        }
        return this.del(keyList);
    }

    @Override
    public long delTotalSignByDate(@NonNull LocalDate date) throws UnsupportedEncodingException {
        byte[] key = this.buildTotalSignKey(date);
        return this.del(key);
    }

    @Override
    public long delTotalSignByDate(@NonNull List<LocalDate> dates) throws UnsupportedEncodingException {
        ArrayList<byte[]> keyList = new ArrayList<byte[]>();
        for (LocalDate date : dates) {
            keyList.add(this.buildTotalSignKey(date));
        }
        return this.del(keyList);
    }

    @Override
    public boolean doSign(@NonNull String uid, @NonNull LocalDate date) throws UnsupportedEncodingException {
        List pipelineList;
        int offset = date.getDayOfMonth() - 1;
        byte[] key = this.buildSignKey(uid, date);
        byte[] totalKey = this.buildTotalSignKey(date);
        byte[] dayKey = this.buildDayKey(date);
        try (RedisConnection connection = this.getConnection();){
            connection.openPipeline();
            connection.setBit(key, (long)offset, true);
            connection.hIncrBy(totalKey, dayKey, 1L);
            connection.expire(key, this.signProperties.getUserExpired().longValue());
            connection.expire(totalKey, this.signProperties.getTotalExpired().longValue());
            pipelineList = connection.closePipeline();
        }
        catch (RedisPipelineException e) {
            log.error(String.format("\u7528\u6237\u7b7e\u5230\u9519\u8bef-redis \u64cd\u4f5c\u9519\u8bef: uid=%s, date=%s", uid, SignUtil.formatDate(date, PATTERN)), (Throwable)e);
            return false;
        }
        return Optional.of(Boolean.valueOf((Boolean)pipelineList.get(0))).orElse(false);
    }

    @Override
    public boolean checkSign(@NonNull String uid, @NonNull LocalDate date) throws UnsupportedEncodingException {
        int offset = date.getDayOfMonth() - 1;
        byte[] key = this.buildSignKey(uid, date);
        try (RedisConnection connection = this.getConnection();){
            Boolean isSign = connection.getBit(key, (long)offset);
            boolean bl = Optional.ofNullable(isSign).orElse(false);
            return bl;
        }
    }

    @Override
    public long getSignCount(@NonNull String uid, @NonNull LocalDate date) throws UnsupportedEncodingException {
        byte[] key = this.buildSignKey(uid, date);
        try (RedisConnection connection = this.getConnection();){
            Long success = connection.bitCount(key);
            long l = Optional.ofNullable(success).orElse(0L);
            return l;
        }
    }

    @Override
    public long getTotalSignCount(@NonNull LocalDate date) throws UnsupportedEncodingException {
        Map monthMap;
        byte[] totalKey = this.buildTotalSignKey(date);
        try (RedisConnection connection = this.getConnection();){
            monthMap = connection.hGetAll(totalKey);
        }
        if (monthMap != null) {
            return monthMap.values().stream().mapToLong(b -> {
                try {
                    return Long.parseLong(new String((byte[])b, this.charset));
                }
                catch (Exception e) {
                    log.error(String.format("\u83b7\u53d6\u6240\u6709\u7528\u6237\u7b7e\u5230\u603b\u6b21\u6570\u9519\u8bef: date=%s", SignUtil.formatDate(date, PATTERN)), (Throwable)e);
                    return 0L;
                }
            }).sum();
        }
        return -1L;
    }

    @Override
    public long getContinuousSignCount(@NonNull String uid, @NonNull LocalDate date) throws UnsupportedEncodingException {
        List list;
        int signCount = 0;
        byte[] key = this.buildSignKey(uid, date);
        BitFieldSubCommands subCommands = BitFieldSubCommands.create().get(BitFieldSubCommands.BitFieldType.unsigned((int)date.getDayOfMonth())).valueAt(0L);
        try (RedisConnection connection = this.getConnection();){
            list = connection.bitField(key, subCommands);
        }
        if (list != null && list.size() > 0) {
            long v = list.get(0) == null ? 0L : (Long)list.get(0);
            for (int i = 0; i < date.getDayOfMonth(); ++i) {
                if (v >> 1 << 1 == v) {
                    if (i > 0) {
                        break;
                    }
                } else {
                    ++signCount;
                }
                v >>= 1;
            }
        }
        return signCount;
    }

    @Override
    public LocalDate getFirstSignDate(@NonNull String uid, @NonNull LocalDate date) throws UnsupportedEncodingException {
        Long pos = -1L;
        byte[] key = this.buildSignKey(uid, date);
        try (RedisConnection connection = this.getConnection();){
            pos = connection.bitPos(key, true);
        }
        return pos != null && pos < 0L ? null : date.withDayOfMonth((int)(pos + 1L));
    }

    @Override
    public Map<String, Boolean> getSignInfo(@NonNull String uid, @NonNull LocalDate date) throws UnsupportedEncodingException {
        List list;
        HashMap<String, Boolean> signMap = new HashMap<String, Boolean>(date.getDayOfMonth());
        byte[] key = this.buildSignKey(uid, date);
        BitFieldSubCommands subCommands = BitFieldSubCommands.create().get(BitFieldSubCommands.BitFieldType.unsigned((int)date.lengthOfMonth())).valueAt(0L);
        try (RedisConnection connection = this.getConnection();){
            list = connection.bitField(key, subCommands);
        }
        this.fillingSignMap(date, signMap, date.lengthOfMonth(), 0, Optional.ofNullable(list).orElse(new ArrayList(0)));
        return signMap;
    }

    @Override
    public Map<String, Boolean> getSignInfoForTheLastFewDays(@NonNull String uid, @NonNull LocalDate date) throws UnsupportedEncodingException {
        return this.getSignInfoForTheLastFewDays(uid, date, this.signProperties.getLastFewDays());
    }

    @Override
    public Map<String, Boolean> getSignInfoForTheLastFewDays(@NonNull String uid, @NonNull LocalDate date, int lastFewDays) throws UnsupportedEncodingException {
        int dayOfMonth = date.getDayOfMonth();
        HashMap<String, Boolean> signMap = new HashMap<String, Boolean>(dayOfMonth);
        if (dayOfMonth >= lastFewDays) {
            this.fillingSignDetail2SignMap(lastFewDays, dayOfMonth - lastFewDays, uid, date, dayOfMonth, dayOfMonth - lastFewDays, signMap);
        } else {
            this.fillingSignDetail2SignMapOfCrossMonth(uid, date, dayOfMonth, lastFewDays, signMap);
        }
        return signMap;
    }

    private void fillingSignMap(@NonNull LocalDate date, @NonNull Map<String, Boolean> signMap, int lowDay, int beforeOfHighDay, @NonNull List<Long> list) {
        if (list.size() > 0) {
            long v = list.get(0) == null ? 0L : list.get(0);
            for (int i = lowDay; i > beforeOfHighDay; --i) {
                LocalDate d = date.withDayOfMonth(i);
                signMap.put(SignUtil.formatDate(d, PATTERN), v >> 1 << 1 != v);
                v >>= 1;
            }
        }
    }

    private void fillingSignDetail2SignMapOfCrossMonth(@NonNull String uid, @NonNull LocalDate date, int dayOfMonth, int lastFewDays, @NonNull Map<String, Boolean> signMap) throws UnsupportedEncodingException {
        List preMonthList;
        List currentMonthList;
        LocalDate preMonthsDate = date.minusMonths(1L);
        int lengthOfPreMonth = preMonthsDate.lengthOfMonth();
        int remainingDays = lastFewDays - dayOfMonth;
        int currentMonthType = dayOfMonth;
        int currentMonthOffset = 0;
        int currentMonthLowDay = dayOfMonth;
        int currentMonthBeforeOfHighDay = 0;
        int preMonthType = remainingDays;
        int preMonthOffset = lengthOfPreMonth - remainingDays;
        int preMonthLowDay = lengthOfPreMonth;
        int preMonthBeforeOfHighDay = lengthOfPreMonth - remainingDays;
        byte[] key = this.buildSignKey(uid, date);
        BitFieldSubCommands subCommands = BitFieldSubCommands.create().get(BitFieldSubCommands.BitFieldType.unsigned((int)currentMonthType)).valueAt((long)currentMonthOffset);
        byte[] preMonthKey = this.buildSignKey(uid, preMonthsDate);
        BitFieldSubCommands preMonthSubCommands = BitFieldSubCommands.create().get(BitFieldSubCommands.BitFieldType.unsigned((int)preMonthType)).valueAt((long)preMonthOffset);
        try (RedisConnection connection = this.getConnection();){
            currentMonthList = connection.bitField(key, subCommands);
            preMonthList = connection.bitField(preMonthKey, preMonthSubCommands);
        }
        this.fillingSignMap(date, signMap, currentMonthLowDay, currentMonthBeforeOfHighDay, Optional.ofNullable(currentMonthList).orElse(new ArrayList(0)));
        this.fillingSignMap(preMonthsDate, signMap, preMonthLowDay, preMonthBeforeOfHighDay, Optional.ofNullable(preMonthList).orElse(new ArrayList(0)));
    }

    private void fillingSignDetail2SignMap(int type, int offset, @NonNull String uid, @NonNull LocalDate date, int lowDay, int beforeOfHighDay, @NonNull Map<String, Boolean> signMap) throws UnsupportedEncodingException {
        List list;
        byte[] key = this.buildSignKey(uid, date);
        BitFieldSubCommands subCommands = BitFieldSubCommands.create().get(BitFieldSubCommands.BitFieldType.unsigned((int)type)).valueAt((long)offset);
        try (RedisConnection connection = this.getConnection();){
            list = connection.bitField(key, subCommands);
        }
        this.fillingSignMap(date, signMap, lowDay, beforeOfHighDay, Optional.ofNullable(list).orElse(new ArrayList(0)));
    }

    private long del(@NonNull List<byte[]> keyList) throws UnsupportedEncodingException {
        Long result;
        byte[][] bytesKey = new byte[keyList.size()][];
        keyList.toArray((T[])bytesKey);
        try (RedisConnection connection = this.getConnection();){
            result = connection.del((byte[][])bytesKey);
        }
        return Optional.ofNullable(result).orElse(0L);
    }

    private long del(@NonNull byte[] key) throws UnsupportedEncodingException {
        Long result;
        try (RedisConnection connection = this.getConnection();){
            result = connection.del((byte[][])new byte[][]{key});
        }
        return Optional.ofNullable(result).orElse(0L);
    }
}

