/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.api.session.strategy;

import java.io.IOException;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.security.web.session.InvalidSessionStrategy;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import top.dcenter.ums.security.core.util.AuthenticationUtil;
import top.dcenter.ums.security.core.util.MvcUtil;

public final class DefaultRedirectInvalidSessionStrategy
implements InvalidSessionStrategy {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final String destinationUrl;
    private final RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
    private boolean createNewSession = true;
    private final AntPathMatcher matcher;
    private final RequestCache requestCache;

    public DefaultRedirectInvalidSessionStrategy(String invalidSessionUrl) {
        Assert.isTrue((boolean)UrlUtils.isValidRedirectUrl((String)invalidSessionUrl), (String)"url must start with '/' or with 'http(s)'");
        this.destinationUrl = invalidSessionUrl;
        this.matcher = new AntPathMatcher();
        this.requestCache = new HttpSessionRequestCache();
    }

    public void onInvalidSessionDetected(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession();
        String redirectUrl = this.destinationUrl;
        String requestUri = MvcUtil.getUrlPathHelper().getPathWithinApplication(request);
        String originalUrl = null;
        if (AuthenticationUtil.isPermitUri(requestUri, session, this.matcher)) {
            redirectUrl = requestUri;
        } else {
            SavedRequest savedRequest = this.requestCache.getRequest(request, response);
            originalUrl = request.getRequestURL().toString();
            if (savedRequest != null) {
                originalUrl = Objects.requireNonNullElse(savedRequest.getRedirectUrl(), originalUrl);
            }
        }
        this.logger.debug((Object)("Starting new session (if required) and redirecting to '" + redirectUrl + "'"));
        if (this.createNewSession) {
            request.getSession();
        }
        session = request.getSession();
        session.removeAttribute("SESSION_ENHANCE_CHECK_KEY");
        if (originalUrl != null) {
            session.setAttribute("SESSION_REDIRECT_URL_KEY", (Object)originalUrl);
        }
        this.redirectStrategy.sendRedirect(request, response, redirectUrl);
    }

    public void setCreateNewSession(boolean createNewSession) {
        this.createNewSession = createNewSession;
    }
}

