/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.api.session.strategy;

import java.util.Comparator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.session.SessionInformation;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.web.authentication.session.ConcurrentSessionControlAuthenticationStrategy;
import org.springframework.security.web.authentication.session.SessionAuthenticationException;
import org.springframework.security.web.authentication.session.SessionFixationProtectionEvent;
import org.springframework.util.Assert;
import org.springframework.web.util.WebUtils;
import top.dcenter.ums.security.core.api.session.SessionEnhanceCheckService;
import top.dcenter.ums.security.core.properties.ClientProperties;

public class EnhanceConcurrentControlAuthenticationStrategy
extends ConcurrentSessionControlAuthenticationStrategy
implements ApplicationEventPublisherAware {
    private static final Logger log = LoggerFactory.getLogger(EnhanceConcurrentControlAuthenticationStrategy.class);
    private SessionEnhanceCheckService sessionEnhanceCheckService;
    private ApplicationEventPublisher applicationEventPublisher = new NullEventPublisher();
    private boolean exceptionIfMaximumExceeded = false;
    private int maximumSessions = 1;
    private final SessionRegistry sessionRegistry;
    private final ClientProperties clientProperties;
    private boolean alwaysCreateSession;

    public EnhanceConcurrentControlAuthenticationStrategy(SessionEnhanceCheckService sessionEnhanceCheckService, SessionRegistry sessionRegistry, ClientProperties clientProperties) {
        super(sessionRegistry);
        this.sessionEnhanceCheckService = sessionEnhanceCheckService;
        this.sessionRegistry = sessionRegistry;
        this.clientProperties = clientProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAuthentication(Authentication authentication, HttpServletRequest request, HttpServletResponse response) {
        if (this.clientProperties.getSession().getSessionNumberControl().booleanValue()) {
            HttpSession session;
            int allowedSessions;
            List sessions = this.sessionRegistry.getAllSessions(authentication.getPrincipal(), false);
            int sessionCount = sessions.size();
            if (sessionCount < (allowedSessions = this.getMaximumSessionsForThisUser(authentication))) {
                return;
            }
            if (allowedSessions == -1) {
                return;
            }
            if (sessionCount == allowedSessions && (session = request.getSession(false)) != null) {
                for (SessionInformation si : sessions) {
                    if (!si.getSessionId().equals(session.getId())) continue;
                    return;
                }
            }
            this.allowableSessionsExceeded(sessions, allowedSessions, this.sessionRegistry);
        } else {
            boolean hadSessionAlready;
            boolean bl = hadSessionAlready = request.getSession(false) != null;
            if (!hadSessionAlready && !this.alwaysCreateSession) {
                return;
            }
            HttpSession session = request.getSession();
            if (hadSessionAlready && request.isRequestedSessionIdValid()) {
                String newSessionId;
                String originalSessionId;
                Object mutex;
                Object object = mutex = WebUtils.getSessionMutex((HttpSession)session);
                synchronized (object) {
                    originalSessionId = session.getId();
                    session = this.applySessionFixation(request);
                    newSessionId = session.getId();
                }
                if (originalSessionId.equals(newSessionId)) {
                    log.warn("session-fixation attacks: Your servlet container did not change the session ID when a new session was created. You will not be adequately protected against session-fixation attacks");
                }
                this.onSessionChange(originalSessionId, session, authentication);
                if (this.sessionEnhanceCheckService != null) {
                    this.sessionEnhanceCheckService.setEnhanceCheckValue(session, request);
                }
            }
        }
    }

    protected void allowableSessionsExceeded(List<SessionInformation> sessions, int allowableSessions, SessionRegistry registry) throws SessionAuthenticationException {
        if (this.exceptionIfMaximumExceeded || sessions == null) {
            throw new SessionAuthenticationException(this.messages.getMessage("ConcurrentSessionControlAuthenticationStrategy.exceededAllowed", new Object[]{allowableSessions}, "Maximum sessions of {0} for this principal exceeded"));
        }
        sessions.sort(Comparator.comparing(SessionInformation::getLastRequest));
        int maximumSessionsExceededBy = sessions.size() - allowableSessions + 1;
        List<SessionInformation> sessionsToBeExpired = sessions.subList(0, maximumSessionsExceededBy);
        for (SessionInformation session : sessionsToBeExpired) {
            session.expireNow();
        }
    }

    protected void onSessionChange(String originalSessionId, HttpSession newSession, Authentication auth) {
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new SessionFixationProtectionEvent(auth, originalSessionId, newSession.getId()));
    }

    public void setExceptionIfMaximumExceeded(boolean exceptionIfMaximumExceeded) {
        super.setExceptionIfMaximumExceeded(exceptionIfMaximumExceeded);
        this.exceptionIfMaximumExceeded = exceptionIfMaximumExceeded;
    }

    HttpSession applySessionFixation(HttpServletRequest request) {
        request.changeSessionId();
        return request.getSession();
    }

    public void setMaximumSessions(int maximumSessions) {
        Assert.isTrue((maximumSessions != 0 ? 1 : 0) != 0, (String)"MaximumLogins must be either -1 to allow unlimited logins, or a positive integer to specify a maximum");
        super.setMaximumSessions(maximumSessions);
        this.maximumSessions = maximumSessions;
    }

    public void setApplicationEventPublisher(@NotNull ApplicationEventPublisher applicationEventPublisher) {
        Assert.notNull((Object)applicationEventPublisher, (String)"applicationEventPublisher cannot be null");
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void setAlwaysCreateSession(boolean alwaysCreateSession) {
        this.alwaysCreateSession = alwaysCreateSession;
    }

    protected static final class NullEventPublisher
    implements ApplicationEventPublisher {
        protected NullEventPublisher() {
        }

        public void publishEvent(@NotNull ApplicationEvent event) {
        }

        public void publishEvent(@NotNull Object event) {
        }
    }
}

