/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.api.validate.code;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.context.request.ServletWebRequest;
import top.dcenter.ums.security.core.auth.validate.codes.ValidateCode;
import top.dcenter.ums.security.core.auth.validate.codes.ValidateCodeType;
import top.dcenter.ums.security.core.enums.ErrorCodeEnum;
import top.dcenter.ums.security.core.exception.ValidateCodeException;

public interface ValidateCodeProcessor {
    public boolean produce(ServletWebRequest var1) throws ValidateCodeException;

    public ValidateCodeType getValidateCodeType();

    public ValidateCode generate(ServletWebRequest var1);

    public boolean saveSession(ServletWebRequest var1, ValidateCode var2);

    public boolean sent(ServletWebRequest var1, ValidateCode var2);

    public void validate(ServletWebRequest var1) throws ValidateCodeException;

    default public void defaultValidate(ServletWebRequest request, String requestParamValidateCodeName) throws ValidateCodeException {
        HttpServletRequest req = request.getRequest();
        ValidateCodeType validateCodeType = this.getValidateCodeType();
        String sessionKey = validateCodeType.getSessionKey();
        HttpSession session = req.getSession();
        ValidateCode codeInSession = (ValidateCode)session.getAttribute(sessionKey);
        String codeInRequest = request.getParameter(requestParamValidateCodeName);
        if (codeInSession == null) {
            throw new ValidateCodeException(ErrorCodeEnum.VALIDATE_CODE_EXPIRED, req.getRemoteAddr(), codeInRequest);
        }
        if (!StringUtils.isNotBlank((CharSequence)codeInRequest)) {
            session.removeAttribute(sessionKey);
            throw new ValidateCodeException(ErrorCodeEnum.VALIDATE_CODE_NOT_EMPTY, req.getRemoteAddr(), validateCodeType.name());
        }
        codeInRequest = codeInRequest.trim();
        if (codeInSession.isExpired()) {
            session.removeAttribute(sessionKey);
            throw new ValidateCodeException(ErrorCodeEnum.VALIDATE_CODE_EXPIRED, req.getRemoteAddr(), codeInRequest);
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)codeInSession.getCode(), (CharSequence)codeInRequest)) {
            if (!codeInSession.getReuse().booleanValue()) {
                session.removeAttribute(sessionKey);
            }
            throw new ValidateCodeException(ErrorCodeEnum.VALIDATE_CODE_ERROR, req.getRemoteAddr(), codeInRequest);
        }
        session.removeAttribute(sessionKey);
    }
}

