/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import top.dcenter.ums.security.core.api.config.HttpSecurityAware;
import top.dcenter.ums.security.core.config.SmsCodeLoginAutoAuthenticationConfigurer;
import top.dcenter.ums.security.core.properties.SmsCodeLoginAuthenticationProperties;

@Configuration
@ConditionalOnProperty(prefix="ums.mobile.login", name={"sms-code-login-is-open"}, havingValue="true")
@AutoConfigureAfter(value={SmsCodeLoginAutoAuthenticationConfigurer.class})
public class SmsCodeLoginAuthenticationAutoConfigurerAware
implements HttpSecurityAware {
    private static final Logger log = LoggerFactory.getLogger(SmsCodeLoginAuthenticationAutoConfigurerAware.class);
    @Autowired(required=false)
    private SmsCodeLoginAutoAuthenticationConfigurer smsCodeLoginAutoAuthenticationConfigurer;
    private final SmsCodeLoginAuthenticationProperties smsCodeLoginAuthenticationProperties;

    public SmsCodeLoginAuthenticationAutoConfigurerAware(SmsCodeLoginAuthenticationProperties smsCodeLoginAuthenticationProperties) {
        this.smsCodeLoginAuthenticationProperties = smsCodeLoginAuthenticationProperties;
    }

    @Override
    public void postConfigure(HttpSecurity http) {
    }

    @Override
    public void preConfigure(HttpSecurity http) throws Exception {
        if (this.smsCodeLoginAutoAuthenticationConfigurer != null) {
            http.apply((SecurityConfigurerAdapter)this.smsCodeLoginAutoAuthenticationConfigurer);
        }
    }

    @Override
    public Map<String, Map<String, Set<String>>> getAuthorizeRequestMap() {
        HashMap<String, Object> permitAllMap = new HashMap<String, Object>(16);
        permitAllMap.put(this.smsCodeLoginAuthenticationProperties.getLoginProcessingUrlMobile(), null);
        HashMap<String, Map<String, Set<String>>> resultMap = new HashMap<String, Map<String, Set<String>>>(1);
        resultMap.put("permitAll", permitAllMap);
        return resultMap;
    }
}

